
;;; d-movement--post-command-hook.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: d-movement--post-command-hook.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: Movement functionality
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

;;;
;;; last-command
;;; this-command
;;;

(defun d-movement--post-command-hook-old ()
  (interactive)
  ;;(message "key=%s" (string= " " (this-command-keys))
  ;;(message "key=%s" (if (string= " " (this-command-keys)) "yes" "no"))
  ;;(message "this-command=%s" this-command)
  (when (and (d-movement--is-correct-mode)
             (or (eq this-command 'self-insert-command)
                 (eq this-command 'lisp-indent-line)
                 (eq this-command 'd-control-o)
                 (eq this-command 'dabbrev-expand)
                 (eq this-command 'yank)
                 (eq this-command 'd-backspace-key)
                 (eq this-command 'd-delete-key)
                 (eq this-command 'd-shift-backspace)
                 (eq this-command 'd-shift-delete)
                 (eq this-command 'd-indent-new-comment-line)
                 (eq this-command 'd-quote-key)
                 (eq this-command 'd-complete-lisp)
                 (eq this-command 'd-complete-line)
                 (eq this-command 'sgml-slash)
                 (eq this-command 'd-html--tab-key)
                 (eq this-command 'd-complete-file)
                 ))
    ;;(d-foo)
    (let ((k (this-command-keys)))
      (if (and (stringp k) (string= k " ") (> (current-column) (frame-width)))
          ;;
          ;; NOTE: case of cursor beyond frame width
          ;;
          (progn
            ;;(insert " ")
            ;;(message "You pressed space")
            )
        (d-movement--munge-line)))))

(d-quote
  (setq d-movement--obarray (make-vector 1023 0))
  (intern "self-insert-command"             d-movement--obarray)
  (intern "lisp-indent-line"                d-movement--obarray)
  (intern "d-control-o"                     d-movement--obarray)
  (intern "dabbrev-expand"                  d-movement--obarray)
  (intern "indent-relative"                 d-movement--obarray)
  (intern "indent-for-tab-command"          d-movement--obarray)
  (intern "yank"                            d-movement--obarray)
  (intern "d-backspace-key"                 d-movement--obarray)
  (intern "d-delete-key"                    d-movement--obarray)
  (intern "d-shift-backspace"               d-movement--obarray)
  (intern "d-shift-delete"                  d-movement--obarray)
  (intern "d-indent-new-comment-line"       d-movement--obarray)
  (intern "d-quote-key"                     d-movement--obarray)
  (intern "d-complete-lisp"                 d-movement--obarray)
  (intern "d-complete-line"                 d-movement--obarray)
  (intern "sgml-slash"                      d-movement--obarray)
  ;;(intern "d-html-meta-control-backslash" d-movement--obarray)
  (intern "d-html-tab-key"                  d-movement--obarray)
  (intern "d-complete-file"                 d-movement--obarray)
  )

;; (mapatoms 'd-insert-prin1 d-movement--obarray)
;; (add-hook 'post-command-hook 'd-movement--error-detection)
;;(defun d-movement--error-detection ()
;;  (when (not (member 'd-movement--post-command-hook post-command-hook))
;;    (d-beeps "d-movement--post-command-hook turned off")
;;    (error "hello")))

(add-hook 'post-command-hook 'd-movement--post-command-hook)
;;(add-hook 'pre-command-hook 'd-movement--post-command-hook)

(defun d-movement--post-command-hook ()
  (error "schmu"))

(defun d-movement--post-command-hook ()
  (interactive)
  (when (d-movement--is-correct-mode) ;; (intern-soft (prin1-to-string this-command) d-movement--obarray)
    ;;(d-foo)
    (let ((k (this-command-keys)))
      (if (and (stringp k) (string= k " ") (>= (current-column) (frame-width)))
          ;;
          ;; NOTE: case of cursor beyond frame width
          ;;
          (progn
            ;;(insert " ")
            ;;(message "You pressed space")
            )
        (d-movement--munge-line)
        ))))

(provide 'd-movement-post-command-hook)
