
(if (not (string-match "~www/dlisp/" (car load-path)))
  (setq load-path (cons "~www/dlisp/" load-path)))

(if noninteractive
    (load-file (concat (car load-path) "diagnose.el")))

(require 'd-flock-lisp++)

;;;(CXXCOMM);; (d-latexize--inside-comment)(CXXMMOC)
(defun d-latexize--inside-comment ()
  (save-excursion
    (save-match-data
      (let ((p (point)))
        (when (re-search-backward "(CXXCOMM)" nil t)
          (when (re-search-forward "(CXXMMOC)" nil t)
            (> (point) p)))))))

(defun d-latexize--inside-string ()
  (save-excursion
    (save-match-data
      (let ((p (point)))
        (when (re-search-backward "(CXXSTRI)" nil t)
          (when (re-search-forward "(CXXIRTS)" nil t)
            (> (point) p)))))))

(defun d-latexize--inside-func ()
  (save-excursion
    (save-match-data
      (let ((p (point)))
        (when (re-search-backward "(CXXFUNC)" nil t)
          (when (re-search-forward "(CXXCNUF)" nil t)
            (> (point) p)))))))

(defun d-latexize--inside-hash ()
  (save-excursion
    (save-match-data
      (let ((p (point)))
        (when (re-search-backward "(CXXHASH)" nil t)
          (when (re-search-forward "(CXXHSAH)" nil t)
            (> (point) p)))))))

(defun d-latexize--inside-prvt ()
  (save-excursion
    (save-match-data
      (let ((p (point)))
        (when (re-search-backward "(CXXPRVT)" nil t)
          (when (re-search-forward "(CXXTVRP)" nil t)
            (> (point) p)))))))

(defun d-latexize--inside-glbl ()
  (save-excursion
    (save-match-data
      (let ((p (point)))
        (when (re-search-backward "(CXXGLBL)" nil t)
          (when (re-search-forward "(CXXLBLG)" nil t)
            (> (point) p)))))))

(defun d-latexize--inside-jtw ()
  (save-excursion
    (save-match-data
      (let ((p (point)))
        (when (re-search-backward "(CXXJTW)" nil t)
          (when (re-search-forward "(CXXWTJ)" nil t)
            (> (point) p)))))))

(defun d-latexize--inside-clss ()
  (save-excursion
    (save-match-data
      (let ((p (point)))
        (when (re-search-backward "(CXXCLSS)" nil t)
          (when (re-search-forward "(CXXSSLC)" nil t)
            (> (point) p)))))))

(defun d-latexize--inside-vari ()
  (save-excursion
    (save-match-data
      (let ((p (point)))
        (when (re-search-backward "(CXXVARI)" nil t)
          (when (re-search-forward "(CXXIRAV)" nil t)
            (> (point) p)))))))

(defun d-latexize--inside-comment-or-string ()
  (or (d-latexize--inside-comment)
      (d-latexize--inside-string)
      (d-latexize--inside-func)
      (d-latexize--inside-hash)
      (d-latexize--inside-prvt)
      (d-latexize--inside-glbl)
      (d-latexize--inside-jtw)
      (d-latexize--inside-clss)
      (d-latexize--inside-vari)
      ))

(defun checkpoint (&rest args) (message "*** checkpoint %s" args))

;; (d-goto-char-safe -5)
;; (d-goto-char-safe (+ (point-max) 5))
(defun d-goto-char-safe (p)
  "Safely goto char, clamps to within the range (point-min) ... (point-max)"
  (goto-char (min (max (point-min) p) (point-max))))

(defun doit ()
  (interactive)
  (let ((case-fold-search nil)
        (debug-on-error   t)
        mode-emacs-lisp mode-emacs-lisp++ mode-c++)

    (checkpoint "checkpoint:1")

    (when (or (not (boundp '*target*)) (not *target*))
      ;;(setq *target* "d:/home/c++-projects/lisp++2c++-lisp++2c++.el")
      ;;(setq *target* "/media/C1TB/home/c++-projects/lisp++2c++-cclass.el")
      ;;(setq *target* "d:/home/c++-projects/2012/Arithmetickles/arithmetickles.lisp++")
      ;;(setq *target* "~/c++-projects/2012/Arithmetickles/glyph_a.lisp++")
      (setq *target* "~/c++-projects/2012/cpause/my_time_sharing_system.h++")
      (setq *target* "~/c++-projects/2006/libd/ptr.hh")
      )

    (checkpoint "checkpoint:2")

    (assert (boundp '*target*))
    (assert *target*)
    (message "*** d-latexize found file=%s" *target*)

    (checkpoint "checkpoint:3")

    (setq mode-emacs-lisp nil)
    (setq mode-emacs-lisp++ nil)
    (setq mode-c++ nil)
    (setq mode-java nil)

    ;;(message "**** *target*=%s" *target*)

    (if (string-match "\\.el$" *target*)
        (setq mode-emacs-lisp t))

    (if (string-match "\\.lisp\\+\\+$" *target*)
        (setq mode-emacs-lisp++ t))

    (if (or (string-match "\\.c$" *target*)
            (string-match "\\.h$" *target*)
            (string-match "\\.hh$" *target*)
            (string-match "\\.ch$" *target*)
            (string-match "\\.cc$" *target*)
            (string-match "\\.h\\+\\+$" *target*)
            (string-match "\\.ch\\+\\+$" *target*)
            (string-match "\\.c\\+\\+$" *target*))
        (setq mode-c++ t))

    (if (string-match "\\.java$" *target*)
        (setq mode-java t))

    (checkpoint "checkpoint:4")

    (setq *buf* (find-file *target*))
    (read-only-mode -1)

    (assert (or mode-emacs-lisp mode-emacs-lisp++ mode-c++ mode-java))

    (if mode-emacs-lisp
        (emacs-lisp-mode))
    (if mode-emacs-lisp++
        (c++-mode))
    (if mode-c++
        (c++-mode))
    (if mode-java
        (java-mode))

    ;;(emacs-lisp-mode)
    ;;(message "*** debug-on-error=%s" debug-on-error)
    ;;(message "*** case-fold-search=%s" case-fold-search)

    (progn
      (goto-char (point-min))
      (while (re-search-forward "" nil t)
        (replace-match "^L" 'fixedcase)))

    (checkpoint "checkpoint:5")

    (goto-char (point-min))
    (while (re-search-forward "{" nil t)
      (replace-match "(ZZ){" 'fixedcase))

    (checkpoint "checkpoint:6")

    (goto-char (point-min))
    (while (re-search-forward "}" nil t)
      (replace-match "(ZZ)}" 'fixedcase))

    (checkpoint "checkpoint:7")

    ;;(message "**** mode-emacs-lisp=%s" mode-emacs-lisp)

    (when mode-emacs-lisp
      (goto-char (point-min))
      (while (re-search-forward "\\(^\\|[^;]\\);;[^;]" nil t);;(not (d-latexize--inside-comment)))
        (save-excursion
          (d-goto-char-safe (- (point) 3))
          (skip-chars-backward " \t")
          (insert "(CXXCOMM){(ZZ)color{comm}{")
          (end-of-line)
          (insert "}}(CXXMMOC)"))))

    (checkpoint "checkpoint:8")

    (when mode-emacs-lisp
      (goto-char (point-min))
      (while (and (re-search-forward ";;;" nil t)
                  (not (d-latexize--inside-comment)))
        (save-excursion
          (d-goto-char-safe (- (point) 3))
          (skip-chars-backward " \t")
          (insert "(CXXCOMM){(ZZ)bf(ZZ)color{red}{")
          (end-of-line)
          (forward-line 1)
          ;; (d-latexize--inside-comment) => t
          (insert "}}(CXXMMOC)"))))

    (checkpoint "checkpoint:9")

    (when (or mode-emacs-lisp++ mode-c++ mode-java)
      (assert (or (eq major-mode 'c++-mode)
                  (eq major-mode 'java-mode)))
      (goto-char (point-min))
      (while (and ;;(re-search-forward "[ ]//[ ]" nil t)
                  (re-search-forward "\\(^\\|[^/]\\)//[^/]" nil t)
                  ;;(not (d-latexize--inside-comment))
                  )
        (save-excursion
          (d-goto-char-safe (- (point) 3))
          (skip-chars-backward " \t")
          (insert "(CXXCOMM){(ZZ)color{comm}{")
          (end-of-line)
          (insert "}}(CXXMMOC)")
          ;;(message "**** line=%s bolp=%s" (d-current-line-as-string) (bolp))
          )))

    (checkpoint "checkpoint:10")

    (when (or mode-emacs-lisp++ mode-c++ mode-java)
      (goto-char (point-min))
      (while (and (re-search-forward "///" nil t)
                  (not (d-latexize--inside-comment)))
        (d-goto-char-safe (- (point) 3))
        (skip-chars-backward " \t")
        (insert "(CXXCOMM){(ZZ)bf(ZZ)color{red}{")
        (end-of-line)
        (insert "}}(CXXMMOC)")))

    (checkpoint "checkpoint:11")

    (when (or mode-emacs-lisp++ mode-c++ mode-java)
      (goto-char (point-min))
      (while (re-search-forward "/\\*\\*" nil t)
        (save-excursion
          (d-goto-char-safe (- (point) 2))
          (when t;;(not (d-latexize--inside-comment))
            (skip-chars-backward " \t")
            (insert "(CXXCOMM){(ZZ)bf(ZZ)color{red}{")
            (re-search-forward "*/")
            (insert "}}(CXXMMOC)")))))

    (checkpoint "checkpoint:12")

    (when (or mode-emacs-lisp++ mode-c++ mode-java)
      (goto-char (point-min))
      (while (and (re-search-forward "/\\*" nil t)
                  (not (d-latexize--inside-comment)))
        (save-excursion
          (d-goto-char-safe (- (point) 2))
          (skip-chars-backward " \t")
          (insert "(CXXCOMM){(ZZ)color{comm}{")
          (re-search-forward "*/")
          (insert "}}(CXXMMOC)"))))

    (checkpoint "checkpoint:13")

    (progn
      (goto-char (point-min)) ;;                            12345678
      (while (re-search-forward (concat "\\([^\\]\\)\\(\"\\(\\\\\\\\\\|"
                                        "\\\\^\\|\\\\\'\\|\\\\\"\\|"
                                        "\\\\t\\|\\\\r\\|\\\\n\\|"
                                        "\\\\$\\|[^\"\\\r\n\t]\\)*\"\\)") nil t)
        (if (not (d-latexize--inside-comment))
            (replace-match "\\1(CXXSTRI){(ZZ)bf(ZZ)colorbox{blue}{(ZZ)color{white}{\\2}}}(CXXIRTS)" 'fixedcase)
          )))

    (checkpoint "checkpoint:14")

    (d-quote when mode-c++
      (goto-char (point-min))
      (while (re-search-forward "<[A-Z][a-zA-Z0-9_]*>" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "(CXXCLSS){(ZZ)color{clss}{\\&}}(CXXSSLC)" 'fixedcase))))

    ;;(checkpoint "checkpoint:14a")
    (checkpoint "checkpoint:15")

    (when (eq major-mode 'c++-mode)
      (goto-char (point-min))
      (while (re-search-forward "operator[ \t]*\\([^ \t()]+\\)[ \t]*(" nil t)
        (when (not (d-latexize--inside-comment-or-string))
          (setq str (buffer-substring-no-properties (match-beginning 1) (match-end 1)))
          ;;(message "str=%s" str)
          (cond
           ((string= str "=")
            (replace-match "{(ZZ)bf(ZZ)color{black}{operator}} {(ZZ)colorbox{func}{=}}(" 'fixedcase)
            ;;(error "operator =")
            )
           ((string= str "")
            (replace-match "{(ZZ)bf(ZZ)color{black}{operator}} {(ZZ)colorbox{func}{Empty}}(" 'fixedcase)
            (error "Empty string in operator"))
           ((string= str "<<")
            (replace-match "{(ZZ)bf(ZZ)color{black}{operator}} {(ZZ)colorbox{func}{<<}}(" 'fixedcase))
           (t
            (replace-match  "{(ZZ)bf(ZZ)color{black}{operator}} {(ZZ)colorbox{func}{\\1}}(" 'fixedcase)
            ;;(error "str=" str)
           ))))
      )

    (checkpoint "checkpoint:15a")
    ;;(checkpoint "checkpoint:15b")

    (when mode-c++
      (goto-char (point-min))
      (while (re-search-forward "::ctor(" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "(CXXVARI)::{(ZZ)bf(ZZ)color{numb}ctor}((CXXIRAV)" 'fixedcase))))

    (checkpoint "checkpoint:16")

    (when mode-emacs-lisp
      (goto-char (point-min))
      (while (re-search-forward "\\<red[-a-zA-Z0-9_]*\\>" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "(CXXVARI){(ZZ)color{red}{\\&}}(CXXIRAV)" 'fixedcase))))

    (checkpoint "checkpoint:17")

    (when (eq major-mode 'c++-mode)
      (goto-char (point-min))
      (while (re-search-forward "namespace \\([a-zA-Z0-9_]+\\)" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "namespace {(ZZ)color{red}{\\1}}" 'fixedcase))))

    (checkpoint "checkpoint:18")

    (when mode-c++
      (goto-char (point-min))
      (while (re-search-forward "\\([A-Z][a-zA-Z0-9_]*\\)::\\([a-z][a-zA-Z0-9_]*\\)(" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "(CXXFUNC){(ZZ)color{clss}{\\1}}::{(ZZ)bf(ZZ)colorbox{func}{\\2}}(CXXCNUF)(" 'fixedcase))))

    (checkpoint "checkpoint:19")

    (when mode-c++
      (goto-char (point-min))
      (while (re-search-forward "\\([A-Z][a-zA-Z0-9_]*\\)::\\([a-z][a-zA-Z0-9_]*\\)" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "(CXXCLSS){(ZZ)color{clss}{\\1}}::{(ZZ)color{vari}{\\2}}(CXXSSLC)" 'fixedcase))))

    (checkpoint "checkpoint:20")

    (when (or (eq major-mode 'c++-mode) (eq major-mode 'java-mode))
      (goto-char (point-min))
      (while (re-search-forward "\\<class \\([A-Za-z_][A-Za-z0-9_]*\\)" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "{(CXXCLSS)(ZZ)bf{}class} {(ZZ)color{clss}{\\1}}(CXXSSLC)" 'fixedcase))))

    (when (eq major-mode 'java-mode)
      (goto-char (point-min))
      (while (re-search-forward "void \\([a-z][a-zA-Z0-9_]*\\)(" nil t)
        (replace-match "{(CXXCLSS)(ZZ)color{clss}void(CXXSSLC)} {(CXXFUNC)(ZZ)colorbox{\\1}(CXXCNUF)}(" 'fixedcase))
      )

    (checkpoint "checkpoint:21")

    (when (eq major-mode 'c++-mode)
      (goto-char (point-min))
      (while (progn
               (d-goto-char-safe (- (point) 1))
               (re-search-forward (concat
                                   "\\([^-a-zA-Z0-9_]\\)\\(new\\|delete\\|static\\|virtual\\|"
                                   "struct\\|this\\|const_cast\\|const\\|return\\|namespace\\|"
                                   "switch\\|case\\|break\\|using namespace\\|"
                                   "if\\|else\\|for\\|while\\|do\\|typedef\\|"
                                   "class\\|this\\|template\\|friend\\)\\([^-a-zA-Z0-9_]\\)") nil t))
        (if (save-excursion
              (d-goto-char-safe (- (point) 2))
              (not (d-latexize--inside-comment-or-string)))
            (replace-match "\\1{(ZZ)color{black}(ZZ)bf{\\2}}\\3" 'fixedcase))))

    (checkpoint "checkpoint:22")

    (d-quote
      (goto-char (point-min))
      (while (re-search-forward "\\([a-zA-Z0-9_]+[&*]*\\) operator \\([^ ()]+\\)[ \t]*(" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "(CXXFUNC){(ZZ)color{clss}{\\1}} {(ZZ)bf{operator}} {(ZZ)colorbox{func}{\\2}}(CXXCNUF)(" 'fixedcase))))

    (checkpoint "checkpoint:23")

    (when mode-c++
      (goto-char (point-min))
      (while (re-search-forward "^[ \t]*m?ptr&" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "{(ZZ)color{clss}{\\&}}" 'fixedcase))))

    (checkpoint "checkpoint:23a")

    (when mode-c++
      (goto-char (point-min))
      (while (re-search-forward "\\([a-zA-Z0-9<_]+[> ]*[&*]*\\) \\(~?[a-z][a-zA-Z0-9_]*\\)[ \t]*(" nil t)
        (setq func (buffer-substring-no-properties (match-beginning 2) (match-end 2)))
        (if (and (not (string= "d"     func))
                 (not (string= "self"  func))
                 (not (string= "data"  func))
                 (not (string= "data1" func))
                 (not (string= "operator" func))
                 )
            (if (not (d-latexize--inside-comment-or-string))
                (replace-match "(CXXFUNC){(ZZ)color{clss}{\\1}} {(ZZ)bf(ZZ)colorbox{func}{\\2}}(CXXCNUF)(" 'fixedcase)))))

    (checkpoint "checkpoint:24")

    (when mode-c++
      (goto-char (point-min))
      (while (re-search-forward "\\(^[ \t]*\\)\\(~?m?ptr[a-zA-Z0-9_<]*[> ]*[&*]*\\)(" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "\\1(CXXFUNC){(ZZ)bf(ZZ)colorbox{func}{\\2}}(CXXCNUF)(" 'fixedcase))))

    (checkpoint "checkpoint:25")

    (when mode-c++
      (goto-char (point-min))
      (while (re-search-forward "\\([(),]\\)\\(~?m?ptr[a-zA-Z0-9_<]*[> ]*\\)(" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "\\1(CXXFUNC){(ZZ)bf(ZZ)colorbox{func}{GET:\\2}}(CXXCNUF)(" 'fixedcase))))

    (checkpoint "checkpoint:26")

    ;;(checkpoint "checkpoint:26a")

    (when mode-c++
      (goto-char (point-min))
      (while (re-search-forward "~?Sprite_Grabber_Action[&*]*" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "(CXXCLSS){(ZZ)color{clss}\\&}(CXXSSLC)" 'fixedcase))))

    (checkpoint "checkpoint:27")

    (when mode-c++
      (goto-char (point-min))
      (while (re-search-forward "~?My_Time_Sharing_System[&*]*" nil t)
        (if (and (not (d-latexize--inside-comment))
                 (not (d-latexize--inside-string)))
            (replace-match "(CXXCLSS){(ZZ)color{clss}\\&}(CXXSSLC)" 'fixedcase))))

    (checkpoint "checkpoint:28")

    (when mode-c++
      (goto-char (point-min))
      (while (re-search-forward "~?Sprite[&*]*" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "(CXXCLSS){(ZZ)color{clss}\\&}(CXXSSLC)" 'fixedcase))))

    (checkpoint "checkpoint:29")
    ;;(checkpoint "checkpoint:29a")

    (when mode-c++
      (goto-char (point-min))
      (while (re-search-forward "\\([(, ]\\)\\(m?ptr[a-zA-Z0-9_<]*[> ]*[&*]*\\) \\([a-z][a-zA-Z0-9_]*\\)\\([ ,)]\\)" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "\\1{(ZZ)color{clss}{\\2}} {(ZZ)color{vari}{\\3}}\\4" 'fixedcase))))

    (checkpoint "checkpoint:30")

    (when mode-c++
      (goto-char (point-min))
      (while (re-search-forward "\\([(, ]\\)\\([A-Z][a-zA-Z0-9_<]*[> ]*[&*]*\\) \\([a-z][a-zA-Z0-9_]*\\)\\([ ,)]\\)" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "\\1{(ZZ)color{clss}{\\2}} {(ZZ)color{vari}{\\3}}\\4" 'fixedcase))))

    (checkpoint "checkpoint:31")

    (when mode-c++
      (goto-char (point-min))
      (while (re-search-forward "\\(\\(dmp::\\)?\\(int\\|string\\|string_buffer\\)[&*]*\\)\\([ \t]+\\)\\([a-z][a-zA-Z0-9_]*\\)" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "{(ZZ)color{clss}{\\1}}\\4{(ZZ)color{vari}{\\5}}" 'fixedcase))))

    (checkpoint "checkpoint:32")

    (when (or (eq major-mode 'emacs-lisp-mode)
              (eq major-mode 'c++-mode))
      (goto-char (point-min))
      (while (re-search-forward (concat "\\<\\(SHOULD_NEVER_HAPPEN\\|ASSERT_INFO\\|"
                                        "EXIT_SUCCESS\\|EXIT_FAILURE\\|ERROR\\|should_never_happen\\|"
                                        "assert\\|ASSERT\\|true\\|false\\|null\\)\\>") nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "{(ZZ)color{red}{\\&}}" 'fixedcase))))

    (checkpoint "checkpoint:33")

    (d-quote
      (goto-char (point-min))
      (while (re-search-forward "\\(dmp\\)\\(::\\)" nil t)
        (replace-match "{(ZZ)color{red}{\\1}}::" 'fixedcase)))

    (checkpoint "checkpoint:34")

    (d-quote when (eq major-mode 'c++-mode)
      (goto-char (point-min))
      (while (re-search-forward "\\(\\(Reader\\|Writer\\)[&*]*\\)[ \t]+\\([a-z][a-zA-Z0-9_]*\\)" nil t)
        (replace-match "(CXXCLSS){(ZZ)color{clss}{\\1}}(CXXSSLC) (CXXVARI){(ZZ)color{vari}{\\3}}(CXXIRAV)" 'fixedcase)))

    (checkpoint "checkpoint:35")

    (d-quote progn
      (goto-char (point-min))
      (while (re-search-forward "\\<\\(m?ptr[a-zA-Z0-9<]*[> ]*[&*]*\\)[ \t]+\\([a-z][a-zA-Z0-9_]*\\)" nil t)
        (if (save-excursion
              (d-goto-char-safe (- (point) 2))
              (not (d-latexize--inside-comment-or-string)))
            (replace-match "(CXXCLSS){(ZZ)color{clss}\\1}(CXXCLSS) (CXXVARI){(ZZ)color{vari}\\2}(CXXIRAV)" 'fixedcase))))

    (checkpoint "checkpoint:36")

    (d-quote progn
      (goto-char (point-min))
      (while (re-search-forward "\\<\\(\\(string\\|string_buffer\\)[&*]*\\)[ \t]+\\([a-z][a-zA-Z0-9_]*[ \t]*[^ ()]*\\)(" nil t)
        (if (save-excursion
              (d-goto-char-safe (- (point) 2))
              (not (d-latexize--inside-comment-or-string)))
            (replace-match "(CXXCLSS){(ZZ)color{clss}\\1}(CXXCLSS) (CXXFUNC){(ZZ)colorbox{func}\\3}(CXXCNUF)" 'fixedcase))))

    ;;(checkpoint "checkpoint:36a")
    (checkpoint "checkpoint:37")

    (d-quote progn
      (goto-char (point-min))
      (while (re-search-forward "\\<\\(\\(string\\|string_buffer\\)[&*]*\\)[ \t]+\\([a-z][a-zA-Z0-9_]*[ \t]*[^ ()]*\\)" nil t)
        (if (save-excursion
              (d-goto-char-safe (- (point) 2))
              (not (d-latexize--inside-comment-or-string)))
            (replace-match "(CXXCLSS){(ZZ)color{clss}\\1}(CXXCLSS) (CXXVARI){(ZZ)color{vari}\\3}(CXXIRAV)" 'fixedcase))))

    (checkpoint "checkpoint:38")

    (when (eq major-mode 'c++-mode)
      (goto-char (point-min))
      (while (re-search-forward "^[ \t]*\\(#include[ \t]+\\)\\(<[A-Za-z0-9_.]+>\\)" nil t)
        ;;(replace-match "(CXXHASH){(ZZ)color{incl}{#include}} (CXXSTRI){(ZZ)color{blue}{\\2}}(CXXIRTS)(CXXHSAH)" 'fixedcase)
        (replace-match "(CXXHASH){(ZZ)colorbox{incl}{#include}} (CXXSTRI){(ZZ)colorbox{blue}{(ZZ)bf(ZZ)color{white}{\\2}}}(CXXIRTS)(CXXHSAH)" 'fixedcase)
        ))

    (checkpoint "checkpoint:39")

    (when (eq major-mode 'c++-mode)
      (goto-char (point-min))
      (while (re-search-forward "^[ \t]*\\(#include[ \t]+\\)" nil t)
        (replace-match "(CXXHASH){(ZZ)colorbox{incl}{#include}} (CXXHSAH)" 'fixedcase)))

    (checkpoint "checkpoint:40")

    (when (eq major-mode 'c++-mode)
      (goto-char (point-min))
      (while (re-search-forward "^[ \t]*\\(#[a-z]+\\)[ \t]+\\([a-zA-Z_][A-Za-z0-9_]*\\)(" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "(CXXHASH){(ZZ)colorbox{incl}{\\1}} {(ZZ)colorbox{func}{\\2}}(CXXHSAH)(" 'fixedcase)
          )))

    (checkpoint "checkpoint:41")

    (when (eq major-mode 'c++-mode)
      (goto-char (point-min))
      (while (re-search-forward "^[ \t]*\\(#[a-z]+\\)[ \t]+\\([a-zA-Z_][A-Za-z0-9_]*\\)" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "(CXXHASH){(ZZ)colorbox{incl}{\\1}} {(ZZ)color{vari}{\\2}}(CXXHSAH)" 'fixedcase))))

    (checkpoint "checkpoint:42")

    (when (eq major-mode 'c++-mode)
      (goto-char (point-min))
      (while (re-search-forward "^\\([ \t]*\\)\\(#endif\\)" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "\\1(CXXHASH){(ZZ)colorbox{incl}{#endif}}(CXXHSAH)" 'fixedcase))))

    (checkpoint "checkpoint:43")

    (when (eq major-mode 'c++-mode)
      (goto-char (point-min))
      (while (re-search-forward "\\(\\<RLE_SPRITE[&*]*\\)[ \t]+\\([a-z][a-zA-Z0-9_]*\\)" nil t)
        (if (save-excursion
              (not (d-latexize--inside-comment-or-string)))
            (replace-match "(CXXCLSS){(ZZ)color{clss}{\\1}} {(ZZ)color{vari}{\\2}}(CXXSSLC)" 'fixedcase))))

    (checkpoint "checkpoint:44")

    (d-quote when (eq major-mode 'c++-mode)
      (goto-char (point-min))
      (while (re-search-forward "^[ \t]*\\(\\(unsigned\\|signed\\)?[ \t]*\\(void\\|short\\|int\\|long\\|double\\|m?ptr[a-zA-Z0-9_<]*[ >]*\\|[A-Za-z0-9_<]+[ >]*\\)[&*]*[ \t]*\\)?\\([A-Z][a-zA-Z0-9_]*\\)::\\([a-z][a-zA-Z0-9_]*\\)(" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "(CXXCLSS){(ZZ)color{clss}\\1\\4}(CXXSSLC)::(CXXFUNC){(ZZ)bf(ZZ)colorbox{func}{FORT\\5}}(CXXCNUF)(" 'fixedcase))))

    (checkpoint "checkpoint 45")

    (d-quote when (and (eq major-mode 'c++-mode) mode-c++)
      (goto-char (point-min))
      (while (re-search-forward (concat "\\(^[ \t]*\\(\\(static\\|friend\\|virtual\\)[ \t]+\\)*\\)"
                                        "\\([a-zA-Z0-9_<][> ]*[&*]* \\)operator \\([^ ]+\\)+(") nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "\\1{(CXXFUNC)(ZZ)color{clss}{\\4}}{(ZZ)bf(ZZ)colorbox{func}{{(ZZ)bf{KOPFoperator}}FORT\\5(CXXCNUF)}}(" 'fixedcase))
        ))

    (checkpoint "checkpoint:46")

    (when (and (eq major-mode 'c++-mode) mode-c++)
      (goto-char (point-min))
      (while (re-search-forward (concat "\\(^[ \t]*\\(\\(static\\|friend\\|virtual\\)[ \t]+\\)+\\)"
                                        "\\(\\([^ (){},=]+ \\)+\\)\\([a-z][a-zA-Z0-9_]*[ \t]*\\)(") nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "\\1{(ZZ)color{clss}{\\4}}{(ZZ)bf(ZZ)colorbox{func}{(CXXFUNC)TORT\\6(CXXCNUF)}}(" 'fixedcase))
        ))

    (when mode-emacs-lisp++

      (checkpoint "checkpoint:47")

      (let (result str)
        (goto-char (point-min))
        ;;(setq count1 0)
        ;;(setq count2 0)
        (while (re-search-forward "(\\(cmethod\\|c-static-method\\|cfunction\\|cfriend\\)" nil t)
          (when (re-search-forward "(cret \\([^()]*\\))" (point-at-eol) t)
            (replace-match "(cret {(ZZ)color{clss}(CXXCLSS){\\1}(CXXSSLC)})" 'fixedcase))
          (when (and (re-search-forward "(cname \\([^()]*\\))" (point-at-eol) t)
                     (not (d-latexize--inside-comment-or-string)))
            (setq str (buffer-substring-no-properties (match-beginning 1) (match-end 1)))
            (cond
             ((save-match-data
                (string-match "operator[ \t]*<<" str))
              (replace-match (format "(cname (CXXFUNC){(ZZ)bf{operator}(ZZ)colorbox{func}{<<}}(CXXCNUF))") 'fixedcase)
              ;;(debug "Calisthenics")
              )
             ((save-match-data
                (string-match "operator[ \t]*>>" str))
              (replace-match (format "(cname (CXXFUNC){(ZZ)bf{operator}(ZZ)colorbox{func}{>>}}(CXXCNUF))") 'fixedcase)
              ;;(debug "Both sides now")
              )
             (t
              (save-match-data
                (if (string-match "operator[ \t]*\\([^ ()]*\\)" str)
                    (progn
                      (setq str (substring str (match-beginning 1) (match-end 1)))
                      (setq result t))
                  (setq result nil)
                  (assert (not (string-match "operator" str)))
                  ))
              (if result
                  (replace-match (format "(cname {{(ZZ)bf{operator}}(ZZ)colorbox{func}{(CXXFUNC)%s(CXXCNUF)}})" str) 'fixedcase)
                (replace-match   (format "(cname {(ZZ)bf(ZZ)colorbox{func}{(CXXFUNC)%s(CXXCNUF)}})" str) 'fixedcase)))
              ) ;; end cond
            )))

      (checkpoint "checkpoint:48")

      (progn
        (goto-char (point-min))
        (while (re-search-forward "(\\(c-constructor-method\\|c-destructor-method\\)" nil t)
          (when (re-search-forward "(cname \\([^()]*\\))" (point-at-eol) t)
            (replace-match "(cname {(ZZ)color{clss}(CXXCLSS){\\1}(CXXSSLC)})" 'fixedcase))))

      (checkpoint "checkpoint:49")

      (when mode-emacs-lisp++
        (goto-char (point-min))
        (while (re-search-forward "(\\(cglobal\\|cproperty\\|c-static-property\\)" nil t)
          (when (re-search-forward "(ctype \\([^()]*\\))" (point-at-eol) t)
            (replace-match "(cret {(ZZ)color{clss}(CXXCLSS){\\1}(CXXSSLC)})" 'fixedcase))
          (when (re-search-forward "(cname \\([^()]*\\))" (point-at-eol) t)
            (setq str (buffer-substring-no-properties (match-beginning 1) (match-end 1)))
            (if (save-match-data
                  (string-match "^_[a-z]" str))
                (progn
                  (replace-match  "(cname {(ZZ)colorbox{prvt}(CXXPRVT){\\1}(CXXTVRP)})" 'fixedcase)
                  ;;(error "That man is full of cheer")
                  )
              (replace-match "(cname {(ZZ)color{vari}(CXXVARI){\\1}(CXXIRAV)})" 'fixedcase)))))

      (checkpoint "checkpoint:50")

      ;;(checkpoint "checkpoint:21a")
      ;;(checkpoint "checkpoint:21b")

      (when (eq major-mode 'c++-mode)
        (goto-char (point-min))
        (while (re-search-forward (concat "\\([^a-zA-Z0-9_-]\\)"
                                          "\\(\\(void\\|bool\\|char\\|int\\|"
                                          "float\\|double\\|string\\|string_buffer\\|"
                                          "SAMPLE\\|RLE_SPRITE\\|BITMAP\\|"
                                          "[A-Z]\\|[A-Z]+[a-z][a-zA-Z0-9_]\\|"
                                          "m?ptr[a-zA-Z0-9_<]*[ >]*\\)[&*]*\\)\\([ \t]+\\)"
                                          "\\([^() :,]*\\)\\((?\\)") nil t)
          (when (save-excursion
                  (d-goto-char-safe (- (point) 2))
                  (not (d-latexize--inside-comment-or-string)))
            (setq operator (buffer-substring-no-properties (match-beginning 5) (match-end 5)))
            (if (not (string= operator "operator"))
                (replace-match "\\1{(ZZ)color{clss}{(CXXCLSS)\\2(CXXSSLC)}}\\4{(ZZ)color{vari}{(CXXVARI)\\5(CXXIRAV)}}\\6" 'fixedcase)))))

    )

    (checkpoint "checkpoint:51")

    (when (eq major-mode 'c++-mode)
      (goto-char (point-min))
      (while (re-search-forward "\\([^a-zA-Z0-9_{}]\\)\\(_[a-z][a-zA-Z0-9_]*\\)" nil t)
        (if (and (not (d-latexize--inside-comment))
                 (not (d-latexize--inside-string)))
            (replace-match "\\1{(ZZ)color{black}(ZZ)colorbox{prvt}{(CXXPRVT)\\2(CXXTVRP)}}" 'fixedcase)
          )
        )
      )

    (checkpoint "checkpoint:52")
    (checkpoint "checkpoint:53")

    (progn
      (goto-char (point-min))
      (while (re-search-forward "<" nil t)
        (replace-match "(QQ)<(QQ)" 'fixedcase)))

    (checkpoint "checkpoint:54")

    (progn
      (goto-char (point-min))
      (while (re-search-forward ">" nil t)
        (replace-match "(QQ)>(QQ)" 'fixedcase)))

    (checkpoint "checkpoint:55")

    (progn
      (goto-char (point-min))
      (while (re-search-forward "|" nil t)
        (replace-match "(QQ)|(QQ)" 'fixedcase)))

    (checkpoint "checkpoint:56")

    (when (eq major-mode 'c++-mode)
      (goto-char (point-min))
      (while (re-search-forward "::\\(ctor\\)(" nil t)
        (when (save-excursion
                (goto-char (max 0 (- (point) 2)))
                (not (d-latexize--inside-comment-or-string)))
          (replace-match "::{(ZZ)color{numb}{ctor}}(" 'fixedcase))))

    (checkpoint "checkpoint:57")

    (when (eq major-mode 'c++-mode)
      (goto-char (point-min))
      (while (re-search-forward "\\<destroy_\\([a-z][a-zA-Z0-9_]*\\)" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "(CXXVARI){(ZZ)color{numb}{\\&}}(CXXVARI)" 'fixedcase))))

    (checkpoint "checkpoint:58")

    (when (eq major-mode 'c++-mode)
      (goto-char (point-min))
      (while (re-search-forward "::\\([a-z][a-zA-Z0-9_]*\\)" nil t)
        (setq str (buffer-substring-no-properties (match-beginning 1) (match-end 1)))
        (if (and (not (d-latexize--inside-comment-or-string))
                 (or  (string= str "draw_rle_sprite")
                      (string= str "draw_sprite")
                      (string= str "putpixel")
                      (string= str "getpixel")
                      (string= str "create_rle_sprite")))
            (replace-match "::{(ZZ)color{brown}{\\1}}" 'fixedcase))))

    (checkpoint "checkpoint:59")
    (when (eq major-mode 'c++-mode)
      (goto-char (point-min))
      (while (re-search-forward "\\<allegro_[a-z][a-zA-Z0-9_]*" nil t)
        (replace-match "::{(ZZ)color{brown}{\\&}}" 'fixedcase)))

    (checkpoint "checkpoint:60")

    (when (eq major-mode 'c++-mode)
      (goto-char (point-min))
      (while (re-search-forward "\\<delete_current(" nil t)
        (when (not (d-latexize--inside-comment-or-string))
          (replace-match "{(ZZ)color{numb}{delete_current}}(" 'fixedcase))))

    (checkpoint "checkpoint:61")

    (when mode-emacs-lisp++
      (goto-char (point-min))
      (while (re-search-forward "(cclass \\([a-zA-Z0-9_]*\\)" nil t)
        (replace-match "(cclass {(ZZ)color{clss}{\\1}}" 'fixedcase)))

    (checkpoint "checkpoint:62")

    (when mode-emacs-lisp
      (goto-char (point-min))
      (while (re-search-forward "(defun \\([-a-zA-Z0-9_+*<>:!]*\\)" nil t)
        (if (not (d-latexize--inside-comment-or-string))
           (replace-match "({(ZZ)bf{defun }}{(ZZ)bf(ZZ)colorbox{func}{(CXXFUNC)\\1(CXXCNUF)}}" 'fixedcase)
          ))

      (checkpoint "checkpoint:63")

      (goto-char (point-min))
      (while (re-search-forward "(defmacro \\([-a-zA-Z0-9_+*<>:!]*\\)" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "({(ZZ)bf{}defmacro }{(ZZ)bf(ZZ)colorbox{func}{(CXXFUNC)\\1(CXXCNUF)}}" 'fixedcase)
          ))
      )

    (checkpoint "checkpoint:64")

    (when mode-emacs-lisp
      (goto-char (point-min))
      (while (re-search-forward "\\<\\(jtw\\|ptr\\|warn\\|d\\)-[-a-zA-Z0-9_+<>:]*" nil t)
        (save-excursion
          (d-goto-char-safe (- (point) 3))
          (when (not (d-latexize--inside-comment-or-string))
            (replace-match "{(ZZ)bf(ZZ)color{darkblue}{\\&}}" 'fixedcase)))))

    (checkpoint "checkpoint:65")

    (when mode-emacs-lisp
      (goto-char (point-min))
      (while (re-search-forward "\\<\\(provide\\|require\\)\\>" nil t) ;; " {(ZZ)color{clss}{'\\([-a-zA-Z0-9_+*<>:!]+\\)}})" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "{(ZZ)bf{\\1}}"))));;" '{(ZZ)color{red}{\\2}})"))))

    (checkpoint "checkpoint:66")

    (when (eq major-mode 'emacs-lisp-mode)
      (goto-char (point-min))
      (while (re-search-forward "\\<\\(read-str\\)\\>" nil t)
        (save-excursion
          (d-goto-char-safe (- (point) 3))
          (when (not (d-latexize--inside-comment-or-string))
            (replace-match "{(ZZ)bf(ZZ)color{clss}{\\&}}" 'fixedcase)))))

    (checkpoint "checkpoint:67")

    (when mode-c++
      (goto-char (point-min))
      (while (re-search-forward "^[ \t]*\\(public\\|private\\|protected\\):" nil t)
        (replace-match "{(ZZ)color{black}(ZZ)bf{\\&}}")))

    (checkpoint "checkpoint:68")

    (when mode-emacs-lisp++
      (while (re-search-forward "(carg\\([^(){}]*\\)[ \t]+\\([^(){}]*\\))" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "(carg{(ZZ)color{clss}{(CXXCLSS)\\1(CXXSSLC)}} {(ZZ)color{vari}{(CXXVARI)\\2(CXXIRAV)}})" 'fixedcase))))

    (checkpoint "checkpoint:69")

    (when (eq major-mode 'c++-mode)
      (goto-char (point-min))
      (while (re-search-forward "\\([^-a-zA-Z0-9_{}()]\\)\\([A-Z][a-zA-Z0-9_]*\\)::" nil t)
        (replace-match "\\1{(ZZ)color{clss}{\\2}}::" 'fixedcase)))

    (checkpoint "checkpoint:69a")

    (when (eq major-mode 'c++-mode)
      (goto-char (point-min))
      (while (re-search-forward "\\([^a-zA-Z0-9_{}]\\)\\([A-Z]\\)::" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "\\1{(ZZ)color{red}{\\2}}::" 'fixedcase))))

    (checkpoint "checkpoint:70")

    (when (eq major-mode 'c++-mode)
      (goto-char (point-min))
      (while (re-search-forward "\\([^a-zA-Z0-9_{}]\\)\\(PRINT\\)\\((.*)\\)" nil t)
        (if (not (save-excursion
                   (forward-char -1)
                   (d-latexize--inside-comment-or-string)))
            (replace-match "\\1{(ZZ)color{glbl}{\\2}}\\3" 'fixedcase))))

    (checkpoint "checkpoint:71")

    (when (eq major-mode 'c++-mode)
      (goto-char (point-min))
      (while (re-search-forward (concat "\\([^a-zA-Z0-9_{}]\\)\\(\\(void\\|bool\\|char\\|int\\|float\\|"
                                        "double\\|string\\|string_buffer\\|BITMAP\\|RLE_SPRITE\\|SAMPLE\\|"
                                        "m?ptr[a-zA-Z0-9_<]*[> ]*\\)[&*]*[ \t]*\\)(") nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "\\1{(ZZ)color{clss}{(CXXCLSS)\\2(CXXSSLC)}}(" 'fixedcase))))

    (checkpoint "checkpoint:72")

    (when mode-emacs-lisp
      (goto-char (point-min))
      (while (re-search-forward "\\*[a-zA-Z_][-a-zA-Z0-9_+]*\\*" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "(CXXGLBL){(ZZ)color{glbl}{\\&}}(CXXLBLG)" 'fixedcase))))

    (checkpoint "checkpoint:73")

    (when mode-emacs-lisp
      (goto-char (point-min))
      (while (re-search-forward "\\<debug\\>" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "{(ZZ)color{numb}{debug}}" 'fixedcase))))

    (checkpoint "checkpoint:74")

    (when (eq major-mode 'c++-mode) ;; \\([(,][ \t\r\n]*\\)
      (goto-char (point-min))       ;; \\([ \t\r\n]*[,)]\\)
      (while (re-search-forward (concat "\\([^a-zA-Z0-9_{}]\\)\\(\\(void\\|bool\\|char\\|int\\|float\\|"
                                        "double\\|string\\|string_buffer\\|BITMAP\\|RLE_SPRITE\\|SAMPLE\\|"
                                        "m?ptr<[A-Za-z0-9_<]*[> ]*\\|[A-Z]\\|"
                                        "[A-Z]+[a-z][a-zA-Z0-9_]*\\)[&*]*[ \t\r\n]+\\)"
                                        "\\([^(),:]+\\)") nil t)
        (when (not (d-latexize--inside-comment-or-string))
          (setq operator (buffer-substring-no-properties (match-beginning 4) (match-end 4)))
          (if (not (string-match "^operator" operator))
              (replace-match "\\1{(ZZ)color{clss}{(CXXCLSS)\\2(CXXSSLC)}}{(ZZ)color{vari}{(CXXVARI)\\4(CXXIRAV)}}" 'fixedcase)))))

    (checkpoint "checkpoint:75")

    (when (eq major-mode 'c++-mode) ;; \\([(,][ \t\r\n]*\\)
      (goto-char (point-min))       ;; \\([ \t\r\n]*[,)]\\)
      (while (re-search-forward (concat "\\([^a-zA-Z0-9_{}]\\)\\(~?[A-Z]\\)\\([^a-zA-Z0-9_{}]\\)") nil t)
        (when (not (d-latexize--inside-comment-or-string))
          (replace-match "\\1{(ZZ)color{clss}{\\2}}\\3" 'fixedcase))))

    (checkpoint "checkpoint:76")

    (when (eq major-mode 'c++-mode)
      (goto-char (point-min))
      (while (re-search-forward (concat "(\\(void\\|bool\\|char\\|int\\|float\\|double\\|"
                                        "string\\|string_buffer\\|SAMPLE\\|RLE_SPRITE\\|BITMAP\\|[A-Z]\\|"
                                        "_?[A-Z]+[a-z][a-zA-Z0-9_]*\\)\\([&*]*\\))") nil t)
        (replace-match "({(ZZ)color{clss}{(CXXCLSS)\\1\\2(CXXSSLC)}})" 'fixedcase)))

    (checkpoint "checkpoint:77")

    (when (eq major-mode 'c++-mode)
      (goto-char (point-min))
      (while (re-search-forward (concat "\\([^a-zA-Z0-9_-{}]\\)\\(\\(void\\|bool\\|"
                                        "char\\|int\\|float\\|double\\|string\\|BITMAP\\|"
                                        "SAMPLE\\|string_buffer\\|"
                                        "RLE_SPRITE\\|m?ptr<[A-Za-z0-9_<>]*[> ]*\\)[*&]*\\)"
                                        "\\([ \t\r\n]+\\)\\([^(),]+\\)") nil t)
        (when (save-excursion
                (d-goto-char-safe (- (point) 3))
                (not (d-latexize--inside-comment-or-string)))
          (setq variable (buffer-substring-no-properties (match-beginning 5) (match-end 5)))
          ;;(if (string= variable "operator") (debug "Xenophobe"))
          (if (not (string-match "^operator" variable))
              (replace-match "\\1{(ZZ)color{clss}{(CXXCLSS)\\2(CXXSSLC)}(ZZ)color{vari}{(CXXVARI)\\4\\5(CXXIRAV)}}" 'fixedcase)))))

    (checkpoint "checkpoint:78")

    (when (eq major-mode 'c++-mode)
      (goto-char (point-min))
      (while (re-search-forward "\\(\\<DCODE_[A-Z0-9_]*\\)" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "{(ZZ)color{green}\\1}" 'fixedcase)
          ;;(replace-match "{(ZZ)colorbox{green}{(ZZ)color{white}\\1}}" 'fixedcase)
          )
        )
      )

    (checkpoint "checkpoint:79")

    (when mode-emacs-lisp++
      (goto-char (point-min))
      (while (re-search-forward "\\<\\([A-Z]\\)\\([:(]\\)" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "{(ZZ)color{clss}{\\1}}\\2" 'fixedcase))))

    (checkpoint "checkpoint:80")

    (when (or mode-emacs-lisp++ mode-c++)
      (goto-char (point-min))
      (while (re-search-forward "\\([^a-zA-Z0-9_]\\)\\(~?[A-Z]+[a-z][A-Za-z0-9_<]*[ >]*[&*]*\\)" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "\\1{(ZZ)color{clss}{\\2}}" 'fixedcase))))

    (checkpoint "checkpoint:81")

    (progn
      (goto-char (point-min))
      (while (re-search-forward "\\^" nil t)
        (replace-match "(ZZ)^{}" 'fixedcase)))

    (checkpoint "checkpoint:82")

    (d-quote when mode-emacs-lisp
      (goto-char (point-min))
      (while (re-search-forward "\\([^-a-zA-Z0-9{}_]\\)\\(ptr[-a-zA-Z0-9_+<>]*[ >]*\\)" nil t)
        (if (save-excursion
              (d-goto-char-safe (- (point) 2))
              (not (d-latexize--inside-comment-or-string)))
            (replace-match "\\1{(ZZ)color{darkblue}(CXXCLSS){\\2}(CXXSSLC)}" 'fixedcase))))

    (checkpoint "checkpoint:83")

    (progn
      (goto-char (point-min))
      (while (re-search-forward "\\([^a-zA-Z0-9_{}]\\)\\(_[a-z][a-zA-Z0-9_]*\\)" nil t)
        (if (and (not (d-latexize--inside-comment))
                 (not (d-latexize--inside-string)))
            (replace-match "\\1{(CXXPRVT)(ZZ)colorbox{prvt}{(ZZ)color{black}{\\2}}(CXXTVRP)}" 'fixedcase)
          )))

    (checkpoint "checkpoint:84")

    (progn
      (goto-char (point-min))
      (while (re-search-forward "\\([^a-zA-Z0-9_{}]\\)\\(private_[A-za-z0-9_]*\\)" nil t)
        (if (and (not (d-latexize--inside-comment))
                 (not (d-latexize--inside-string)))
            (replace-match "\\1{(CXXPRVT)(ZZ)colorbox{prvt}{(ZZ)color{black}{\\2}}(CXXTVRP)}" 'fixedcase)
          )))

    (checkpoint "checkpoint:85")

    (when mode-emacs-lisp
      (goto-char (point-min))
      (while (progn
               (d-goto-char-safe (- (point) 2))
               (re-search-forward "\\([^-a-zA-Z0-9_]\\)\\(\\(global\\|GLOBAL\\)[a-zA-Z0-9_+-]*\\)\\([^a-zA-Z0-9_-]\\)"
                                  nil t))
        (if (not (save-excursion
                   (d-goto-char-safe (- (point) 4))
                   (d-latexize--inside-comment-or-string)))
            (replace-match "\\1{(ZZ)color{glbl}{\\2}}\\4" 'fixedcase))))

    (checkpoint "checkpoint:86")

    (when (or mode-emacs-lisp++ mode-c++)
      (goto-char (point-min))
      (while (re-search-forward "\\([^-a-zA-Z0-9_]\\)\\(\\(global\\|GLOBAL\\)[a-zA-Z0-9_]*\\)\\([^a-zA-Z0-9_]\\)" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "\\1{(ZZ)color{glbl}{\\2}}\\4" 'fixedcase))))

    (checkpoint "checkpoint:87")

    (d-quote when mode-emacs-lisp
      (goto-char (point-min))
      (while (re-search-forward "\\([^-a-zA-Z0-9_]\\)\\(\\(prop\\|PROP\\)[-a-zA-Z0-9_]*\\)\\([^-a-zA-Z0-9_]\\)" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "\\1{(ZZ)color{przp}{\\2}}\\4" 'fixedcase))))

    (checkpoint "checkpoint:88")

    (d-quote when (eq major-mode 'c++-mode) ;;or mode-emacs-lisp++ mode-c++)
      (goto-char (point-min))
      (while (re-search-forward "\\([^a-zA-Z0-9_-]\\)\\(\\(prop\\|PROP\\)[a-zA-Z0-9_]*\\)\\([^a-zA-Z0-9_-]\\)" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "\\1{(ZZ)color{przp}{\\2}}\\4" 'fixedcase))))

    (checkpoint "checkpoint:89")

    (d-quote when (eq major-mode 'c++-mode)
      (goto-char (point-min))
      (while (re-search-forward "\\([^{}]*\\)\\(operator\\) *\\([^ (){},]*\\) *(" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "{(ZZ)color{clss}{\\1}}{(ZZ)bf{}operator}{(ZZ)colorbox{func}{(CXXFUNC)\\3(CXXCNUF)}}(" 'fixedcase)
          )))

    (checkpoint "checkpoint:90")

    (when (eq major-mode 'c++-mode)
      (goto-char (point-min))
      (while (re-search-forward "\\(^\\|[^a-zA-Z0-9_]\\)\\(dmp\\|std\\)::" nil t)
        (if (and (not (d-latexize--inside-comment))
                 (not (d-latexize--inside-string)))
            (replace-match "\\1{(ZZ)color{red}{\\2}}::" 'fixedcase))))

    (checkpoint "checkpoint:91")

    (when (eq major-mode 'c++-mode) ;;mode-emacs-lisp++ mode-c++)

      (checkpoint "checkpoint:92")

      (progn
        (goto-char (point-min))
        (while (re-search-forward "virtual" nil t)
          (if (and (not (d-latexize--inside-comment))
                   (not (d-latexize--inside-string)))
              (replace-match "{(ZZ)color{black}(ZZ)bf{virtual}}" 'fixedcase))))

      (checkpoint "checkpoint:93")

      )

    (checkpoint "checkpoint:94")

    (goto-char (point-min))
    (while (re-search-forward "\\\\" nil t)
      (replace-match "(QQ)(ZZ)backslash(QQ)" 'fixedcase))

    (checkpoint "checkpoint:95")

    (progn
      (goto-char (point-min))
      (while (re-search-forward "\\$" nil t)
        (replace-match "(ZZ)$" 'fixedcase)))

    (checkpoint "checkpoint:96")

    (progn
      (goto-char (point-min))
      (while (search-forward "(QQ)" nil t)
        (replace-match "$" 'fixedcase)))

    (checkpoint "checkpoint:97")

    (progn
      (goto-char (point-min))
      (while (re-search-forward (concat
                                 "\\([^a-zA-Z0-9_.-]\\)\\(*?c-[-a-zA-Z0-9_+*<>]*\\|cret\\|ctype\\|"
                                 "\\*[a-zA-Z0-9]*\\*\\|cname\\|cargs?\\|cinit\\|cprogn\\|"
                                 "cmethod\\|cproperty\\|cpause\\|"
                                 "cfor\\|cforever\\|cwhile\\|cdo\\|cfunction\\|"
                                 "c-public-extends\\|c-private-extends\\|"
                                 "cautogc\\|cif[?]?\\|celseif\\|celse\\|"
                                 "cswitch\\|cbrackets\\|d-quote\\|"
                                 "cenum\\|citems\\|citem\\|"
                                 "cdefine\\|cglobal\\|cclass\\|"
                                 "s\\|f\\|sc\\|clet[*]?\\|cassert\\|"
                                 "c-raw-c++\\|c-raw-h++\\|c-raw-global-h++\\|"
                                 "cnamespace\\|cfriend\\|ctypedef\\|cpublic\\|"
                                 "cprivate\\|cprotected\\)\\([^a-zA-Z0-9_.-]\\)") nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "\\1{(ZZ)color{greenkeyw}{\\2}}\\3" 'fixedcase))))

    (checkpoint "checkpoint:97a")

    (when (or mode-emacs-lisp mode-emacs-lisp++)
      (goto-char (point-min))
      (while (re-search-forward "\\<c-basic-offset\\>" nil t)
        (if (and (not (d-latexize--inside-string))
                 (not (d-latexize--inside-comment)))
            (replace-match "{(ZZ)color{black}{\\&}}" 'fixedcase))))

    (checkpoint "checkpoint:97b")

    (when (or mode-emacs-lisp mode-emacs-lisp++)
      (goto-char (point-min))
      (while (re-search-forward "\\(^\\|[^-a-zA-Z0-9_]\\)\\(\\<\\(prop\\|PROP\\|LOCAL\\|local\\)[-a-zA-Z0-9_]*\\>\\)" nil t)
        (if (and (not (d-latexize--inside-string))
                 (not (d-latexize--inside-comment)))
            (replace-match "\\1{(ZZ)color{orange}{\\2}}" 'fixedcase))))

    (checkpoint "checkpoint:98")

    (when mode-emacs-lisp
      (goto-char (point-min))
      (while (re-search-forward "&[a-zA-Z_][a-zA-Z0-9_]*" nil t)
        (when (not (d-latexize--inside-comment-or-string))
          (replace-match "{(ZZ)color{red}{\\&}}"))))

    (checkpoint "checkpoint:99")

    (when mode-emacs-lisp
      (goto-char (point-min))
      (while (re-search-forward "\\<\\(defvar\\|defmacro\\|defun\\|let\\|let\\*\\|if\\|when\\|while\\|save-excursion\\|progn\\|unwind-protect\\|condition-case\\|save-match-data\\)\\>" nil t)
        (when (not (d-latexize--inside-comment-or-string))
          (replace-match "{(ZZ)bf{\\&}}"))))

    (checkpoint "checkpoint:100")

    (progn
      (goto-char (point-min))
      (while (re-search-forward "\\([a-z]*\\)::\\(cout\\|cerr\\)" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "{(ZZ)color{red}{(ZZ)bf{}\\1}}::\\2" 'fixedcase))))

    (checkpoint "checkpoint:101")

    (progn
      (goto-char (point-min))
      (while (re-search-forward "_" nil t)
        (replace-match "(ZZ)_" 'fixedcase)))

    (checkpoint "checkpoint:102")

    (goto-char (point-min))
    (while (re-search-forward "\\([^-a-zA-Z0-9_]\\)\\(-?[0-9]+\\(\\.[0-9]+\\)?\\)\\([^a-zA-Z0-9_]\\)" nil t)
      (when (save-excursion
              (d-goto-char-safe (- (point) 2))
              (not (d-latexize--inside-comment-or-string)))
        (replace-match "\\1{(ZZ)color{numb}{\\2}}\\4" 'fixedcase)
        (d-goto-char-safe (- (point) 2))))

    (checkpoint "checkpoint:103")

    (goto-char (point-min))
    (while (re-search-forward "\\([^-a-zA-Z0-9_]\\)\\(0[Xx][0-9A-Fa-f]+\\)\\([^-a-zA-Z0-9_]\\)" nil t)
      (when (save-excursion ;;0xDEADBEEF
              (d-goto-char-safe (- (point) 2))
              (not (d-latexize--inside-comment-or-string)))
        (replace-match "\\1{(ZZ)color{numb}{\\2}}\\3" 'fixedcase)))

    (checkpoint "checkpoint:104")

    (goto-char (point-min))
    (while (re-search-forward "~" nil t)
      (replace-match "(ZZ)~{}" 'fixedcase))

    (checkpoint "checkpoint:105")

    (when mode-c++
      (goto-char (point-min))
      (while (re-search-forward "\\(^\\|[^a-zA-Z0-9_]\\)\\(X[&*]*\\)" nil t)
        (if (not (d-latexize--inside-comment-or-string))
            (replace-match "\\1(CXXCLSS){(ZZ)color{clss}{\\2}}(CXXSSLC)" 'fixedcase))))

    (checkpoint "checkpoint:105a")

    (progn
      (goto-char (point-min))
      (while (re-search-forward "&" nil t)
        (replace-match "\\\\&" 'fixedcase)))

    (checkpoint "checkpoint:106")

    (progn
      (goto-char (point-min))
      (while (re-search-forward "#" nil t)
        (replace-match "\\\\#" 'fixedcase)))

    (checkpoint "checkpoint:107")

    (progn
      (goto-char (point-min))
      (while (re-search-forward "%" nil t)
        (replace-match "\\\\%" 'fixedcase)))

    (checkpoint "checkpoint:108")

    (let (count)
      (setq count 0)
      (goto-char (point-min))
      (setq quoted-dollar (regexp-quote "$"))
      (setq count-plus-100 (+ count 100))
      (while (re-search-forward " " nil t)
        (when (save-match-data
                (and (save-excursion
                       (d-goto-char-safe (- (point) 1))
                       (not (looking-at quoted-dollar)))
                     (not (looking-at quoted-dollar))))
          (replace-match "\\\\p{}" 'fixedcase)
          (when (> count count-plus-100)
            (checkpoint (format "checkpoint:109 %s%%" (/ (* 100 (point)) (point-max))))
            (setq count-plus-100 (+ count 100)))
          (incf count)
          )))

    (checkpoint "checkpoint:110")

    (progn
      (goto-char (point-min))
      (while (re-search-forward "(ZZ)" nil t)
        (replace-match "\\\\" 'fixedcase)))

    (checkpoint "checkpoint:111")

    (progn
      (goto-char (point-min))
      (while (and (re-search-forward "^.+$" nil t) (not (eobp)))
        (replace-match "\\\\noindent \\& \\\\\\\\" 'fixedcase)
        (d-goto-char-safe (- (point) 1))))

    (checkpoint "checkpoint:112")

    (progn
      (goto-char (point-min))
      (while (search-forward "(CXXCOMM)" nil t)
        (replace-match "" 'fixedcase))
      (goto-char (point-min))
      (while (search-forward "(CXXMMOC)" nil t)
        (replace-match "" 'fixedcase)))

    (checkpoint "checkpoint:113")

    (progn
      (goto-char (point-min))
      (while (search-forward "(CXXSTRI)" nil t)
        (replace-match "" 'fixedcase))
      (goto-char (point-min))
      (while (search-forward "(CXXIRTS)" nil t)
        (replace-match "" 'fixedcase)))

    (checkpoint "checkpoint:114")

    (progn
      (goto-char (point-min))
      (while (search-forward "(CXXFUNC)" nil t)
        (replace-match "" 'fixedcase))
      (goto-char (point-min))
      (while (search-forward "(CXXCNUF)" nil t)
        (replace-match "" 'fixedcase)))

    (checkpoint "checkpoint:115")

    (progn
      (goto-char (point-min))
      (while (search-forward "(CXXHASH)" nil t)
        (replace-match "" 'fixedcase))
      (goto-char (point-min))
      (while (search-forward "(CXXHSAH)" nil t)
        (replace-match "" 'fixedcase)))

    (checkpoint "checkpoint:116")

    (progn
      (goto-char (point-min))
      (while (search-forward "(CXXPRVT)" nil t)
        (replace-match "" 'fixedcase))
      (goto-char (point-min))
      (while (search-forward "(CXXTVRP)" nil t)
        (replace-match "" 'fixedcase)))

    (checkpoint "checkpoint:117")

    (progn
      (goto-char (point-min))
      (while (search-forward "(CXXGLBL)" nil t)
        (replace-match "" 'fixedcase))
      (goto-char (point-min))
      (while (search-forward "(CXXLBLG)" nil t)
        (replace-match "" 'fixedcase)))

    (checkpoint "checkpoint:118")

    (d-quote progn
      (goto-char (point-min))
      (while (search-forward "(CXXJTW)" nil t)
        (replace-match "" 'fixedcase))
      (goto-char (point-min))
      (while (search-forward "(CXXWTJ)" nil t)
        (replace-match "" 'fixedcase)))

    (checkpoint "checkpoint:119")

    (progn
      (goto-char (point-min))
      (while (search-forward "(CXXVARI)" nil t)
        (replace-match "" 'fixedcase))
      (goto-char (point-min))
      (while (search-forward "(CXXIRAV)" nil t)
        (replace-match "" 'fixedcase)))

    (checkpoint "checkpoint:120")

    (progn
      (goto-char (point-min))
      (while (search-forward "(CXXCLSS)" nil t)
        (replace-match "" 'fixedcase))
      (goto-char (point-min))
      (while (search-forward "(CXXSSLC)" nil t)
        (replace-match "" 'fixedcase)))

    (checkpoint "checkpoint:121")

    (progn
      (goto-char (point-min))
      (while (re-search-forward "{przp}" nil t)
        (replace-match "{prop}" 'fixedcase)))

    (checkpoint "checkpoint:122")

    (write-file (concat *target* ".tex"))
    (kill-buffer *buf*)

    (message "*** end of file")
    ))

(provide 'd-latexize)
;;; d-latexize.el ends here

