/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ClassFile;
import gnu.jel.LocalField;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import junit.framework.TestCase;

public class ClassFileTest
extends TestCase {
    ClassFile cf;

    public ClassFileTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        LocalField[] lf = new LocalField[]{new LocalField(2, new Object[0].getClass(), "e", null)};
        this.cf = new ClassFile(1, "dump", new Object().getClass(), null, lf);
    }

    @Override
    public void tearDown() throws Exception {
    }

    public void testAdd2UTF() throws Exception {
        String s1 = "some string";
        ClassFileTest.assertEquals(this.cf.getUTFIndex(s1), this.cf.getUTFIndex(s1));
    }

    public void testAdd2Long() throws Exception {
        ClassFileTest.assertEquals(this.cf.getIndex(new Long(15L), 5), this.cf.getIndex(new Long(15L), 5));
    }

    public void testAdd2Int() throws Exception {
        ClassFileTest.assertEquals(this.cf.getIndex(new Integer(15), 4), this.cf.getIndex(new Integer(15), 4));
    }

    public void testAdd2Float() throws Exception {
        ClassFileTest.assertEquals(this.cf.getIndex(new Float(15.0f), 6), this.cf.getIndex(new Float(15.0f), 6));
    }

    public void testAdd2Double() throws Exception {
        ClassFileTest.assertEquals(this.cf.getIndex(new Double(15.0), 7), this.cf.getIndex(new Double(15.0), 7));
    }

    public void testAdd2Str() throws Exception {
        String s1 = "some string";
        ClassFileTest.assertEquals(this.cf.getUTFIndex(s1), this.cf.getUTFIndex(s1));
        String s2 = "some other string";
        ClassFileTest.assertEquals(this.cf.getIndex(s2, 8), this.cf.getIndex(s2, 8));
        ClassFileTest.assertEquals(this.cf.getIndex(s1, 8), this.cf.getIndex(s1, 8));
    }

    public void testAdd2Cls() throws Exception {
        ClassFileTest.assertEquals(this.cf.getIndex(this.cf.getClass(), 9), this.cf.getIndex(this.cf.getClass(), 9));
    }

    public void testAdd2Mth() throws Exception {
        Class[] params = new Class[]{Class.forName("gnu.jel.ClassFile")};
        Method a_method = this.getClass().getMethod("dumpImage", params);
        ClassFileTest.assertEquals(this.cf.getIndex(a_method, 10), this.cf.getIndex(a_method, 10));
    }

    public static void dumpImage(ClassFile cf) throws Exception {
        FileOutputStream fos = new FileOutputStream("dump.class");
        fos.write(cf.getImage());
        fos.close();
    }
}

