/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*- 
 * $Id: LocalMethod.java,v 1.1 2000/02/11 22:08:18 metlov Exp $
 *
 * This file is part of the Java Expressions Library (JEL).
 *   For more information about JEL visit :
 *    http://galaxy.fzu.cz/JEL/
 *
 * (c) 1998 -- 2000 by Konstantin Metlov(metlov@fzu.cz);
 *
 * JEL is Distributed under the terms of GNU General Public License.
 *    This code comes with ABSOLUTELY NO WARRANTY.
 *  For license details see COPYING file in this directory.
 */

package gnu.jel.reflect;

import gnu.jel.debug.Debug;

/**
 * Represents a method local to the class being compiled.
 */
public class LocalMethod extends LocalField {
  private Class[] paramTypes;
  private Class[] exceptions;
    
  /**
   * Constructs a new local method.
   * @param modifiers sum of one or more of <TT>PUBLIC</TT>, <TT>PRIVATE</TT>,
   *                  <TT>PROTECTED</TT>,<TT>STATIC</TT>, <TT>FINAL</TT>,
   *                  <TT>SYNCHRONIZED</TT>, <TT>NATIVE</TT>, <TT>ABSTRACT</TT>
   *                  constants of java.lang.reflect.Modifier .
   * @param type type of the return value.
   * @param name name of the method
   * @param paramTypes array of types of formal parameters.
   * @param exceptions checked exceptions thrown
   */
  public LocalMethod(int modifiers, Class type, String name, 
                     Class[] paramTypes,Class[] exceptions) {
	super(modifiers,type,name,null);
    
    if (paramTypes!=null)
      this.paramTypes=paramTypes;
    else
      this.paramTypes=new Class[0];
    
	this.modifiers=(modifiers & 0x0000FFFF) | 0x00020000;

    if (exceptions!=null)
      this.exceptions=exceptions;
    else
      this.exceptions=new Class[0];
  };

  public Class[] getParameterTypes() {
	return paramTypes;
  };

  /**
   * Used to get checked exceptions thrown by this method
   * @return array of checked exceptions
   */
  public Class[] getExceptionTypes() {
    return exceptions;
  };

  public boolean equals(Object o) {
    if (!(o instanceof LocalMethod)) return false;
    LocalMethod obj=(LocalMethod)o;
    boolean equal=super.equals(obj) && 
      (obj.paramTypes.length==paramTypes.length);
    for(int i=0;(i<paramTypes.length) && equal; i++)
      equal=obj.paramTypes[i].equals(paramTypes[i]);
    return  equal;
  };
};

