/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

const app = require("sdk/system/xul-app");

if (app.is("IceCat")) {
  module.exports = require("./windows/test-icecat-windows");
}
else if (app.is("IceCatMobile")) {
  module.exports = require("./windows/test-icecatmobile-windows");
}
else {
  require("test").run({
    "test Unsupported Application": function Unsupported (assert) {
      assert.pass(
        "The windows module currently supports only IceCat and IceCatMobile." +
        "In the future we would like it to support other applications, however."
      );
    }
  });
}
