/*  GFAX - Gnome fax application
 *  Copyright (C) 1999 George A. Farris
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef HYLAFAX_SENDFAX_H
#define HYLAFAX_SENDFAX_H

#include "ftplib.h"

enum hylafax_errno {
	EOK = 0,
	EERROR,
	ENOLOGIN,
	ELOGININCORRECT,
	ENOSERVERFILE,
	ENOSERVER,
	ENOSTORE,
	ENOLOCALFILE
};

enum hylafax_errno hylafax_connect(netbuf **con);
enum hylafax_errno hylafax_sendfax(Destination *dest);
enum hylafax_errno hylafax_faxstat(netbuf *con, 
				   gchar *queueName, gchar *jobfmt, 
				   GPtrArray *queue);
enum hylafax_errno hylafax_server_state(netbuf *con, GString *output);
enum hylafax_errno hylafax_faxrm(netbuf *con, gchar *id);
void hylafax_disconnect(netbuf *con, gboolean showResult, 
			enum hylafax_errno herrno);
char *hylafax_getlog(void);

#endif
