/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *  Copyright 1999 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 *    Create May 25, 1998 Matthew L. Welborn
 */
#define FOUR  1
#define EIGHT 0
#define SYNC_VERSION        1
#define PULSE_VERSION       0

#include "VrFileSource.h"
#include "VrSigSource.h"
#include "VrDigMod.h"
#include "VrSyncFilter.h"
#include "VrCorr.h"
#include "VrComplexPlotSink.h"
#include "VrUDPSource.h"
#include "VrFileSink.h"
#include "VrScopeSink.h"
#include "VrAWGN.h"
#include "VrMultiTask.h"
#include "VrGUI.h"

#define DEFAULT_TPD	2600.0
int process_one = 1;
int persistent = 0;

VrSyncFilter<char>* filter1;
VrSyncFilter<char>* filter2;
VrScopeSink<float> *scopesink;

VrAWGN<char>* noise;
int center_freq_mult = 4; //jca 4;
int out_rate = 400000; //400000;
int in_rate = 2000; //2000; 

void set_freq_offset_1(double f) {
  filter1->setCenter_Freq(((center_freq_mult) * in_rate) - f);
}
void set_filter_taps_1(double t) {
  filter1->setNumber_Taps((int)t);
}
void set_noise(double f) {
  noise->setSNR((int)f);
}
void set_clear()
{
  scopesink->clear();
}
void set_my_scale(double f) {
printf ("set scale %f\n", f);
  scopesink->setScale(f);
  scopesink->clear();
}
void set_persistent()
{
	persistent = 1 - persistent;
	scopesink->set_persistent(persistent);
}

int main(int argc,char** argv)
{
  VrGUI *guimain = new VrGUI(argc, argv);
  float dummy, repeat_bump;
  char *xmt_data, *rec_data;
  int right, wrong, offset, num;
  int dec = out_rate / in_rate, dec_corr = dec/10;
  VrUDPSource<char>* source = new VrUDPSource<char>(out_rate, 5001);
  filter1 = new VrSyncFilter<char>(dec,50,(float)((center_freq_mult) * in_rate),1.0/800.0);
  filter2 = new VrSyncFilter<char>(dec/10,20,(float)((center_freq_mult) * in_rate),1.0/800.0);
  VrCorr<VrComplex, float>* corr = new VrCorr<VrComplex,float>(dec_corr, 10, 2, 4);
  noise = new VrAWGN<char>();

  (void) VrGUISpace(guimain->top, 10);
  (void) VrGUILabel(guimain->top, "Correlation result", 0, 30);
  VrGUILayout *scopelay_main = guimain->top->horizontal();
  VrGUILayout *scopelay = scopelay_main->vertical();
  scopesink = new VrScopeSink<float>(scopelay, DEFAULT_TPD/2, -128, 128, 1);
  VrGUILayout *scopelay_slider = scopelay->horizontal();
  (void) new VrGUISlider(scopelay_slider, set_my_scale, "Time", DEFAULT_TPD/100, DEFAULT_TPD);
  VrGUILayout *scopelay2 = scopelay_main->vertical();
  (void) new VrGUIButton(scopelay2, "Store", set_persistent);
  (void) new VrGUIButton(scopelay2, "Clear", set_clear);
  (void) VrGUISpace(scopelay2, 50);


  (void) VrGUILabel(guimain->top, "Signal constellation", 0, 30);
  VrComplexPlotSink* sink      = new VrComplexPlotSink(guimain->top, (VrPulse<char,char> *)filter1,.05,2);
  (void) new VrGUISlider(guimain->top, set_freq_offset_1, "Frequency error", -100.0, 100.0);
  (void) new VrGUISlider(guimain->top, set_filter_taps_1, "Filter Taps", 10.0, 200.0);
  //  (void) new VrGUISlider(guimain->top, set_noise, "SNR (dB)", 5.0, 72.0);

  CONNECT(scopesink, corr, out_rate, 32);
  CONNECT(corr, filter2, out_rate / dec, 64);
  CONNECT(filter2, noise, out_rate, 8);
  CONNECT(sink, filter1, out_rate / dec, 64);
  CONNECT(filter1, noise, out_rate, 8);
  CONNECT(noise, source, out_rate, 8);

  VrMultiTask *m = new VrMultiTask();
  m->add(sink);  
  m->add(scopesink);  
  m->start(); 
  guimain->start();

  filter1 -> setSymbol_Timing((float)0.0);
  dummy = filter1 -> getSymbol_Period();
  cout << "Original period: " << dummy << endl;
  if(argc==2) filter1 -> setSymbol_Period(atof(argv[1]));
  if(argc==3) {
    filter1 -> setSymbol_Period(atof(argv[1]));
    filter1 -> setSymbol_Timing(atof(argv[2]));
  }
  repeat_bump = 0.0;
  if(argc==4) {
    filter1 -> setSymbol_Period(atof(argv[1]));
    filter1 -> setSymbol_Timing(atof(argv[2]));
    repeat_bump = atof(argv[3]);
  }
 
  offset = 3;
  while(1) {
    right = 0;
    wrong = 0;
    guimain->processEvents(10 /*ms*/);
	if (1 || process_one) {
		process_one = 0;
    	m->process(); 
#if 0
    	rec_data = sink -> getRcvdData();
    	for( int i = 0; i < num-offset; i++){
      		//      cout << "x" << (int)*(xmt_data+i)<< "r" << (int)*(rec_data+i+offset)<< endl;
#if 0
      		if (*(xmt_data+i) == 0x01) cout << "x1 " ;
      		if (*(rec_data+i+offset) == 0x00) cout << "r0 "<< endl;
      		if (*(rec_data+i+offset) == 0x01) cout << "r1 " << endl;
#endif
       		//   cout << (int) *(xmt_data+i) << "  " << (int) *(rec_data+offset+i) << endl;
      		if (*(xmt_data+i) == *(rec_data+offset+i)) {
				right ++;
      		} else {
				wrong ++;
      		}
    	}
#endif
    	filter1 -> setSymbol_Timing(repeat_bump);
	}
  } /* while(1) */
}
