/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *  Copyright 1999 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */

/*
 * Standalone simulator for the wireless channel
 */

#include "VrFileSource.h"
#include "VrSigSource.h"
#include "VrUDPSource.h"

#include "VrFileSink.h"
#include "VrScopeSink.h"
#include "VrUDPSink.h"

#include "VrSum.h"
#include "VrAWGN.h"
#include "VrConnect.h"
#include "VrMultiTask.h"
#include "VrGUI.h"

#define	SAMPLING_FREQ		     33e6
#define MAX_FREQUENCY		1000000.0     //  1Mhz
#define FREQUENCY                 20000.0     // 20Khz
#define DEFAULT_TPD		 10000/10     //divisions

VrSigSource<char> *sigsource;
VrFileSource<char>* filesource;
VrScopeSink<char> *scopesink;
VrUDPSource<char>* udpsource;
VrAWGN<char>* noise;
VrUDPSink<char>* udpsink;
VrSum<char,char>*summer = new VrSum<char,char>();

void set_my_freq(double f) {
  sigsource->setFrequency(f);
}
void set_my_scale(double f) {
  scopesink->setScale(f);
}
void set_noise(double f) {
  noise->setSNR((int)f);
}

int main(int argc, char **argv)
{
  VrGUI *guimain = new VrGUI(argc, argv);

  filesource = new VrFileSource<char>(SAMPLING_FREQ, "../../data_files/8_sym_sync.char",1);
  (void) VrGUILabel(guimain->top, "Wireless channel", 0, 30);
  udpsource = new VrUDPSource<char>(SAMPLING_FREQ, 5001);
  udpsink = new VrUDPSink<char>("localhost", 5001);
  noise = new VrAWGN<char>();
  sigsource = new VrSigSource<char>(SAMPLING_FREQ, VR_SIN_WAVE, 1000/*FREQUENCY*/, 1e6);
  scopesink = new VrScopeSink<char>(guimain->top, DEFAULT_TPD, -128, 127);

  (void) new VrGUISlider(guimain->top, set_my_scale, "Time per division (microseconds)", DEFAULT_TPD/100, DEFAULT_TPD);

  CONNECT(udpsink, sigsource, SAMPLING_FREQ, 8);

  (void) new VrGUINumber(guimain->top, "Signal Generator", "Frequency (cycles/sec)", set_my_freq,
		MAX_FREQUENCY, FREQUENCY);

  VrMultiTask *m = new VrMultiTask();
  m->add(scopesink);  
  m->add(udpsink);  
  m->start(); 
  guimain->start();
  while (1) {
    guimain->processEvents(10 /*ms*/);
    m->process();
  }
}
