#ifndef _TUNER_H_
#define _TUNER_H_

#include <qobject.h>

class Tuner : public QObject
{
  Q_OBJECT

protected:  
  int min;
  int max;
  int chan;
  bool wrap;

public:
  Tuner(int min, int max, int chan, 
	QObject *parent = 0, const char *name = 0);

  int minChannel() const;
  int maxChannel() const;
  int channel() const;
  virtual double frequency() const = 0;
  bool isWrap() const;
  void setWrap(bool on);

signals:
  void channelChanged(int channel);

public slots:  
  void setChannel(int channel);
  void nextChannel();
  void prevChannel();
};

inline
Tuner::Tuner(int min, int max, int chan,
	     QObject *parent = 0, const char *name = 0) :
  QObject(parent, name),
  min(min),
  max(max),
  chan(chan)
{}

inline
int
Tuner::minChannel() const
{ return min; }

inline
int
Tuner::maxChannel() const
{ return max; }

inline
int
Tuner::channel() const
{ return chan; }

inline
bool
Tuner::isWrap() const 
{ return wrap; }

inline
void
Tuner::setWrap(bool on)
{ wrap = on; }

#endif
