/* -*- Mode: c++ -*- 
 *
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */


#ifndef _VRNOP_H_
#define _VRNOP_H_

#include <VrSigProc.h>

/*** This module just copies its input to its output ***/
template<class ioType> 
class VrNop : public VrSigProc {
protected:
public: 
  virtual const char *name() { return "VrNop"; }
  virtual int work(VrSampleRange output, void *o[],
		   VrSampleRange inputs[], void *i[]);
  VrNop(): VrSigProc(1, sizeof(ioType), sizeof(ioType)) {};
};

template<class ioType> int
VrNop<ioType>::work(VrSampleRange output, void *ao[],
		VrSampleRange inputs[], void *ai[])
{
  ioType **i = (ioType **)ai;
  ioType **o = (ioType **)ao;

  memcpy(o[0],i[0],output.size*sizeof(ioType));
  return output.size;
}

#endif
