/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _INCLUDED_GR_FLOWGRAPH_H_
#define _INCLUDED_GR_FLOWGRAPH_H_

class VrSigProc;

/*!
 * \brief graph that represents the data flow among VrSigProcs.
 *
 * This class replaces VrMultiTask, the CONNECT macro, and the main
 * processing loop
 */

class gr_FlowGraph {
private:
  // NOT IMPLEMENTED
  // gr_FlowGraph (const gr_FlowGraph &rhs);
  gr_FlowGraph &operator= (const gr_FlowGraph &rhs);

public:
  virtual ~gr_FlowGraph();
  virtual bool start () = 0;	// for thread(s) and return immediately
  virtual void stop () = 0;	// stop threads
  virtual void wait () = 0;	// wait for threads to stop (typically blocks forever)
  virtual bool isRunning () = 0;
  virtual bool connect (VrSigProc *upstream, VrSigProc *downstream) = 0;
  virtual bool connect (VrSigProc *upstream, int upstream_port,
			VrSigProc *downstream) = 0;

  //! class method to create concrete instance
  static gr_FlowGraph *make ();
};

#endif /* _INCLUDED_GR_FLOWGRAPH_H_ */
