/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <GrSerialToParallel.h>

GrSerialToParallel::GrSerialToParallel (int item_size, int items_per_block)
  : VrSigProc (1, item_size, item_size * items_per_block),
    d_item_size (item_size), d_items_per_block (items_per_block)
{
}

GrSerialToParallel::~GrSerialToParallel ()
{
}

void
GrSerialToParallel::pre_initialize ()
{
  if (getSamplingFrequency () == 0.0)
    setSamplingFrequency (getInputSamplingFrequencyN (0) / d_items_per_block);
}

int 
GrSerialToParallel::forecast (VrSampleRange output, VrSampleRange inputs[])
{
  assert (numberInputs == 1);
  
  inputs[0].index = output.index * d_items_per_block;
  inputs[0].size = output.size * d_items_per_block;

  return 0;
}

int 
GrSerialToParallel::work (VrSampleRange output, void *ao[],
			  VrSampleRange inputs[], void *ai[])
{
  int	block_size = d_item_size * d_items_per_block;
  
  char 	*out = ((char **) ao)[0];
  char  *in  = ((char **) ai)[0];

  assert (output.size * block_size == inputs[0].size * d_item_size);

  memcpy (out, in, output.size * block_size);
  return output.size;
}
