/* -*- Mode: c++ -*-
*******************************************************************************
*
* File:         GrLimiter.h
* Description:  Saturation
*
*******************************************************************************
*/

/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _GRLIMITER_H_
#define _GRLIMITER_H_

#include <VrSigProc.h>

template<class iType, class oType>
class GrLimiter : public VrSigProc {

public: 
  virtual const char *name() { return "GrLimiter"; }
  virtual int work(VrSampleRange output, void *o[],
		   VrSampleRange inputs[], void *i[]);
  GrLimiter();
};

template<class iType,class oType> int
GrLimiter<iType,oType>::work(VrSampleRange output, void *ao[],
			      VrSampleRange inputs[], void *ai[])
{
  iType **i = (iType **)ai;
  oType **o = (oType **)ao;
  iType *ip = i[0];
  oType *op = o[0];
  
  int size = output.size;

  while(size-- > 0) 
    *op++ = *ip++>0?1:-1; 
  return output.size;
}

template<class iType,class oType> 
GrLimiter<iType,oType>::GrLimiter()
  : VrSigProc(1, sizeof(iType), sizeof(oType))
{
  setOutputSize (1024);
}

#endif /* _GRLIMITER_H_ */
