/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * WARNING: This file is automatically generated by generate_GrFIRfilterXXX.py
 * Any changes made to this file will be overwritten.
 */

#ifndef _GrFIRfilterFSF_H_
#define	_GrFIRfilterFSF_H_

#include <VrDecimatingSigProc.h>
#include <gr_fir_builderF.h>

class gr_fir_FSF;

/*!
 * \brief FIR filter with float input, short output and float taps
 */

class GrFIRfilterFSF : public VrDecimatingSigProc<float, short>
{
 public:
  /*!
   * Construct a FIR filter with the given taps
   */
  GrFIRfilterFSF (int decimation_factor, const std::vector<float> &taps);

  /*!
   * Construct a FIR filter where the taps will be determined
   * at initialization time by invoking builder->taps (sampling_freq)
   *
   * GrFIRfilterFSF becomes responsible for life time management
   * of builder.
   */
  GrFIRfilterFSF (int decimation_factor, gr_fir_builderF *builder);
  virtual ~GrFIRfilterFSF ();

  virtual const char *name () { return "GrFIRfilterFSF"; }
  virtual void initialize ();
  virtual int work (VrSampleRange output, void *o[],
		    VrSampleRange inputs[], void *i[]);

  void setTaps (const std::vector<float> &taps);

 protected:
  gr_fir_builderF	*d_builder;
  gr_fir_FSF		*d_fir;
  std::vector<float>	d_new_taps;
  int			d_updated;
};

#endif // _GrFIRfilterFSF_H_
