/* 
 *    Programmed By: Mohammed Isam Mohammed [mohammed_isam1984@yahoo.com]
 *    Copyright 2018 (c)
 * 
 *    file: module_html.c
 *    This file is part of mino.
 *
 *    mino is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    mino is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with mino.  If not, see <http://www.gnu.org/licenses/>.
 */    
#include "modules.h"

char *ext_html[] = { "html", "htm", "HTML", "HTM" };
char *keyword_html[] = {
      //HTML language keywords
      "!--",
      "--",
      "!doctype",
      "abbr",
      "acronym",
      "address",
      "applet",
      "area",
      "article",
      "aside",
      "audio",
      "a",
      "basefont",
      "base",
      "bdi",
      "bdo",
      "big",
      "blockquote",
      "body",
      "br",
      "button",
      "b",
      "canvas",
      "caption",
      "center",
      "cite",
      "code",
      "colgroup",
      "col",
      "datalist",
      "dd",
      "del",
      "details",
      "dfn",
      "dialog",
      "dir",
      "div",
      "di",
      "dt",
      "embed",
      "em",
      "fieldset",
      "figcaption",
      "figure",
      "font",
      "footer",
      "form",
      "frameset",
      "frame",
      "h1",
      "h2",
      "h3",
      "h4",
      "h5",
      "h6",
      "header",
      "head",
      "hr",
      "html",
      "iframe",
      "img",
      "input",
      "ins",
      "i",
      "kbd",
      "keygen",
      "label",
      "legend",
      "link",
      "li",
      "main",
      "map",
      "mark",
      "menuitem",
      "menu",
      "meta",
      "meter",
      "nav",
      "noframes",
      "noscript",
      "object",
      "ol",
      "optgroup",
      "option",
      "output",
      "param",
      "pre",
      "progress",
      "p",
      "q",
      "rp",
      "rt",
      "ruby",
      "samp",
      "script",
      "section",
      "select",
      "small",
      "source",
      "span",
      "strike",
      "strong",
      "style",
      "sub",
      "summary",
      "sup",
      "s",
      "table",
      "tbody",
      "td",
      "textarea",
      "tfoot",
      "thead",
      "th",
      "time",
      "title",
      "track",
      "tr",
      "tt",
      "ul",
      "u",
      "var",
      "video",
      "wbr",
};

struct modulestruct module_html =
{
    .extsCount      = 4,
    .exts           = ext_html,
    .keywordCount   = 124,
    .keywords       = keyword_html,
    .mlCommentStart = "<!--",
    .mlCommentEnd   = "-->",
    .slCommentStart = NULL,
    .caseSensitive  = 0,
};
