/*$Id: bm_complex.cc,v 20.5 2001/09/17 15:43:17 al Exp $ -*- C++ -*-
 * Copyright (C) 2001 Albert Davis
 * Author: Albert Davis <aldavis@ieee.org>
 *
 * This file is part of "GnuCap", the Gnu Circuit Analysis Package
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *------------------------------------------------------------------
 * behavioral modeling complex value
 * used with tc, etc, and conditionals
 */
#include "ap.h"
#include "bm.h"
/*--------------------------------------------------------------------------*/
EVAL_BM_COMPLEX::EVAL_BM_COMPLEX(int c)
  :EVAL_BM_ACTION_BASE(c),
   _value(NOT_INPUT)
{
}
/*--------------------------------------------------------------------------*/
EVAL_BM_COMPLEX::EVAL_BM_COMPLEX(const EVAL_BM_COMPLEX& p)
  :EVAL_BM_ACTION_BASE(p),
   _value(p._value)
{
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_COMPLEX::parse(CS& cmd)
{
  int here = cmd.cursor();
  do{
    int paren = cmd.skiplparen();
    double real = NOT_VALID;
    double imag = 0.;
    cmd >> real >> imag;
    {if (cmd.gotit(here)){
      _value = COMPLEX(real,imag);
    }else{
      untested();
    }}
    paren -= cmd.skiprparen();
    if (paren != 0){
      untested();
      cmd.warn(bWARNING, "need )");
    }
    parse_base(cmd);
  }while (cmd.more() && !cmd.stuck(&here));
  parse_base_finish();
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_COMPLEX::print(OMSTREAM& where)const
{
  where << "  " << name() << '(' 
	<< _value.real() << ',' << _value.imag() << ')';
  print_base(where);
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_COMPLEX::tr_eval(ELEMENT* d)const
{
  tr_finish_tdv(d, _value.real());
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_COMPLEX::ac_eval(ELEMENT* d)const
{
  d->_ev = _value;
  ac_final_adjust_with_temp(&(d->_ev));
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
