// Copyright (C) 1999-2001 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// As a special exception to the GNU General Public License, permission is 
// granted for additional uses of the text contained in its release 
// of ccaudio.
// 
// The exception is that, if you link the ccaudio library with other
// files to produce an executable, this does not by itself cause the
// resulting executable to be covered by the GNU General Public License.
// Your use of that executable is in no way restricted on account of
// linking the ccaudio library code into it.
// 
// This exception does not however invalidate any other reasons why
// the executable file might be covered by the GNU General Public License.
// 
// This exception applies only to the code released under the 
// name ccaudio.  If you copy code from other releases into a copy of
// ccaudio, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
// 
// If you write modifications of your own for ccaudio, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.  

#include <cc++/config.h>
#include <cc++/strchar.h>
#include <math.h>
#include "private.h"
#include "audio.h"

#ifndef	M_PI
#define	M_PI	3.14159265358979323846
#endif

#ifdef	CCXX_NAMESPACES
namespace ost {
#endif

AudioRegisterCodec *AudioRegisterCodec::first = NULL;

AudioCodec::AudioCodec(unsigned fsize, Encoding encoding, unsigned rate) :
AudioSample(fsize, encoding, rate)
{
	length = fsize;
}

unsigned AudioCodec::getChannels(void)
{
	if(isMono(encoding))
		return 1;
	else
		return 2;
}

unsigned AudioCodec::load(unsigned char *data, unsigned len)
{
	unsigned maxlen = toBytes(encoding, count);
	if(len > maxlen)
		len = maxlen;

	memcpy(samples, data, len);
	length = toSamples(encoding, len);
	return len;
}

unsigned AudioCodec::save(unsigned char *data, unsigned maxlen)
{
	unsigned len = toBytes(encoding, length);
	if(len > maxlen)
		len = maxlen;
	memcpy(data, samples, len);
	return len;
}

AudioRegisterCodec::AudioRegisterCodec(unsigned min, unsigned def)
{
	minframe = min;
	framecnt = def;
	next = first;
	first = this;
}

AudioCodec *AudioRegisterCodec::findCodec(const char *name, unsigned frames)
{
	AudioRegisterCodec *codec = AudioRegisterCodec::first;

	while(codec)
	{
		if(!stricmp(name, codec->getName()))
		{
			if(!frames)
				frames = codec->getFrameCount();
			return codec->getCodec(frames);
		}
		codec = codec->next;
	}
	return NULL;
}

AudioCodec *AudioRegisterCodec::findCodec(Encoding encoding, unsigned rate, unsigned frames)
{
	AudioRegisterCodec *codec = AudioRegisterCodec::first;

	while(codec)
	{
		if(encoding == codec->getEncoding())
		{
			if(!rate || codec->getRate() == rate)
			{
				if(!frames)
					frames = codec->getFrameCount();
				return codec->getCodec(frames);
			}
		}
		codec = codec->next;
	}
	return NULL;
}

AudioRegisterCodec *AudioRegisterCodec::findRegistration(const char *name)
{
	AudioRegisterCodec *codec = AudioRegisterCodec::first;

	while(codec)
	{
		if(!stricmp(name, codec->getName()))
			return codec;
		codec = codec->next;
	}
	return NULL;
}

AudioRegisterCodec *AudioRegisterCodec::findRegistration(Encoding encoding, unsigned rate)
{
	AudioRegisterCodec *codec = AudioRegisterCodec::first;

	while(codec)
	{
		if(encoding == codec->getEncoding())
		{
			if(!rate || codec->getRate() == rate)
				return codec;
		}
		codec = codec->next;
	}
	return NULL;
}

#ifdef	CCXX_NAMESPACES
};
#endif
