/* translation of file "petrinet-patterns-links.k" */
/* generated by:
 *  @(#)$Author: Kimwitu++ version 2.3.11 (C) 1998-2007 Humboldt-University of Berlin $
 */
#define KC_FUNCTIONS_petrinet_patterns_links

#include <stdlib.h>
#include "ast-system-k.h"
#include "petrinet-patterns-links.h"
namespace kc { }
using namespace kc;
/* included stuff */
#line 27 "petrinet-patterns-links.k"
/*!
 * \file    petrinet-patterns-links.cc
 *
 * \brief   Petri net patterns for the link wrappers
 *
 *          This file implements the wrapper patterns necessary to model
 *          incoming and outgoing links of an activity:
 *           - link wrapper 0: no incoming or outgoing links
 *           - link wrapper 1: outgoing links
 *           - link wrapper 2: incoming links, suppressJoinFailure="yes"
 *           - link wrapper 3: incoming links, suppressJoinFailure="no"
 *           - link wrapper 4: incoming and outgoing links,
 *             suppressJoinFailure="yes"
 *           - link wrapper 5: incoming and outgoing links,
 *             suppressJoinFailure="no"
 *
 * \author  Niels Lohmann <nlohmann@informatik.hu-berlin.de>,
 *          last changes of: \$Author: nielslohmann $
 * 
 * \since   2007-03-04
 *
 * \date    \$Date: 2007/06/28 07:38:17 $
 * 
 * \note    This file is part of the tool BPEL2oWFN and was created during the
 *          project "Tools4BPEL" at the Humboldt-Universitt zu Berlin. See
 *          http://www.informatik.hu-berlin.de/top/tools4bpel for details.
 *
 * \note    This file was created using Kimwitu++ reading file
 *          petrinet-patterns-links.k.
 *          See http://site.informatik.hu-berlin.de/kimwitu++ for details.
 *
 * \version \$Revision: 1.25 $
 */

#line  49 "petrinet-patterns-links.cc"
#line 73 "petrinet-patterns-links.k"
#include <cmath>
#include <set>
#include <map>
#include <string>

#include "ast-config.h"
#include "helpers.h"
#include "ast-tools.h"
#include "ast-details.h"
#include "options.h"
#include "globals.h"
#include "petrinet-patterns-shortcuts.h"

using std::set;
using std::string;
using std::map;

extern PetriNet PN;

#line  70 "petrinet-patterns-links.cc"
#line 102 "petrinet-patterns-links.k"
/*!
 * \fn      void kc::P_LinkWrapper0(impl_standardElements* abstract_phylum, uview current_view)
 *
 * \brief   Wrapper Pattern 0
 *
 *          Wrapper pattern for an activity that has neither incoming nor
 *          outgoing links.
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \ingroup patterns
 */

#line  86 "petrinet-patterns-links.cc"
#line 154 "petrinet-patterns-links.k"
/*!
 * \fn      void kc::P_LinkWrapper1(impl_standardElements* abstract_phylum, uview current_view)
 *
 * \brief   Wrapper Pattern 1
 *
 *          Wrapper pattern for an activity that has only outgoing links.
 *
 *          \image   html "wrapper1.png" "pattern"
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \ingroup patterns
 */

#line  103 "petrinet-patterns-links.cc"
#line 215 "petrinet-patterns-links.k"
/*!
 * \fn      void kc::P_LinkWrapper2(impl_standardElements* abstract_phylum, uview current_view)
 *
 * \brief   Wrapper Pattern 2
 *
 *          Wrapper pattern for an activity that has incoming links only, with
 *          attribute "suppressJoinFailure" set to "yes".
 *
 *          \image html "wrapper2.png" "pattern"
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \ingroup patterns
 */

#line  121 "petrinet-patterns-links.cc"
#line 295 "petrinet-patterns-links.k"
/*!
 * \fn      void kc::P_LinkWrapper3(impl_standardElements* abstract_phylum, uview current_view)
 *
 * \brief   Wrapper Pattern 3
 *
 *          Wrapper pattern for an activity that has incoming links only, with
 *          attribute "suppressJoinFailure" set to "false".
 *
 *          \image html "wrapper3.png" "pattern"
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \note    In mode "communication only", wrapper pattern 2 is used instead.
 *
 * \ingroup patterns
 */

#line  141 "petrinet-patterns-links.cc"
#line 388 "petrinet-patterns-links.k"
/*!
 * \fn      void kc::P_LinkWrapper4(impl_standardElements* abstract_phylum, uview current_view)
 *
 * \brief   Wrapper Pattern 4
 *
 *          Wrapper pattern for an activity that has incoming and outgoing
 *          links, with attribute suppressJoinFailure" set to "yes".
 *
 *          \image html "wrapper4.png" "pattern"
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \ingroup patterns
 *
 * \todo    Check this pattern.
 */

#line  161 "petrinet-patterns-links.cc"
#line 475 "petrinet-patterns-links.k"
/*!
 * \fn      void kc::P_LinkWrapper5(impl_standardElements* abstract_phylum, uview current_view)
 *
 * \brief   Wrapper Pattern 5
 *
 *          Wrapper pattern for an activity that has incoming and outgoing
 *          links, with attribute suppressJoinFailure" set to "no".
 *
 *          \image html "wrapper5.png" "pattern"
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \note    In mode "communication only", wrapper pattern 4 is used instead.
 *
 * \ingroup patterns
 *
 * \todo    Check this pattern.
 */

#line  183 "petrinet-patterns-links.cc"
/* end included stuff */


namespace kc {

#ifndef KC_TRACE_PROVIDED
#define KC_TRACE_PROVIDED(COND,FILE,LINE,NODE) COND
#endif

void P_LinkWrapper0(impl_standardElements *abstract_phylum, uview current_view)
#line 117 "petrinet-patterns-links.k"
{
    impl_standardElements_StandardElements* phylum =
    static_cast<impl_standardElements_StandardElements*>(abstract_phylum);
    assert(phylum != NULL);


    string prefix = toString(phylum->parentId) + ".";
    string newPrefix = toString(phylum->parentId) + ".internal";


    Place *p1 = PN.newPlace(prefix + "initial");
    Place *p2 = PN.newPlace(prefix + "final");


    PN.mergePlaces(p1, newPrefix + ".initial");
    PN.mergePlaces(p2, newPrefix + ".final");


    if (current_view != petrinetsmall_enum)
    {
	Place *p3 = PN.newPlace(prefix + "stop");
	Place *p4 = PN.newPlace(prefix + "stopped");

	PN.mergePlaces(p3, newPrefix + ".stop");
	PN.mergePlaces(p4, newPrefix + ".stopped");
    }

#line 143 "petrinet-patterns-links.k"
}
#line  224 "petrinet-patterns-links.cc"

void P_LinkWrapper1(impl_standardElements *abstract_phylum, uview current_view)
#line 170 "petrinet-patterns-links.k"
{
    trace(TRACE_DEBUG, "[PNU]" + inString() + "  wrapper-pattern 1\n");

    impl_standardElements_StandardElements* phylum =
    static_cast<impl_standardElements_StandardElements*>(abstract_phylum);
    assert(phylum != NULL);


    string prefix = toString(phylum->parentId) + ".";
    string newPrefix = toString(phylum->parentId) + ".internal";


    Place *p1 = PN.newPlace(prefix + "initial");
    Place *p2 = PN.newPlace(prefix + "final");
    Place *p5 = PN.newPlace(prefix + "done");


    P_transitionCondition(prefix, phylum->tSource_list_1);


    PN.mergePlaces(p1, newPrefix + ".initial");
    PN.mergePlaces(p5, newPrefix + ".final");


    if (current_view != petrinetsmall_enum)
    {
	Place *p3 = PN.newPlace(prefix + "stop");
	Place *p4 = PN.newPlace(prefix + "stopped");

	Transition *t = stop(p2, "final", prefix);

	PN.mergePlaces(p3, newPrefix + ".stop");
	PN.mergePlaces(p4, newPrefix + ".stopped");
    }

#line 204 "petrinet-patterns-links.k"
}
#line  265 "petrinet-patterns-links.cc"

void P_LinkWrapper2(impl_standardElements *abstract_phylum, uview current_view)
#line 232 "petrinet-patterns-links.k"
{
    trace(TRACE_DEBUG, "[PNU]" + inString() + "  wrapper-pattern 2\n");

    impl_standardElements_StandardElements* phylum =
    static_cast<impl_standardElements_StandardElements*>(abstract_phylum);
    assert(phylum != NULL);


    string prefix = toString(phylum->parentId) + ".";
    string newPrefix = toString(phylum->parentId) + ".internal";


    Place *p1 = PN.newPlace(prefix + "initial");
    Place *p2 = PN.newPlace(prefix + "final");
    Place *p5 = PN.newPlace(prefix + "jc_true");
    Place *p6 = PN.newPlace(prefix + "jc_false");
    Place *p7 = PN.newPlace(prefix + "begin");






    PN.mergePlaces(p5, p7);


    Transition *t2 = PN.newTransition(prefix + "skip");

    PN.newArc(p6, t2);
    PN.newArc(t2, p2);


    dpeLinks(t2, phylum->parentId);


    P_joinCondition(prefix, phylum->tTarget_list_1, phylum->joinCondition_1);


    PN.mergePlaces(prefix + "begin", newPrefix + ".initial");
    PN.mergePlaces(p2, newPrefix + ".final");


    if (current_view != petrinetsmall_enum)
    {
	Place *p3 = PN.newPlace(prefix + "stop");
	Place *p4 = PN.newPlace(prefix + "stopped");

	Transition *t = stop(p1, "initial", prefix);

	PN.mergePlaces(p3, newPrefix + ".stop");
	PN.mergePlaces(p4, newPrefix + ".stopped");
    }

#line 284 "petrinet-patterns-links.k"
}
#line  324 "petrinet-patterns-links.cc"

void P_LinkWrapper3(impl_standardElements *abstract_phylum, uview current_view)
#line 314 "petrinet-patterns-links.k"
{
    trace(TRACE_DEBUG, "[PNU]" + inString() + "  wrapper-pattern 3\n");

    impl_standardElements_StandardElements* phylum =
    static_cast<impl_standardElements_StandardElements*>(abstract_phylum);
    assert(phylum != NULL);


    string prefix = toString(phylum->parentId) + ".";
    string newPrefix = toString(phylum->parentId) + ".internal";



    if (petrinetsmall_enum == current_view)
    {
	assert(globals::ASTEmap[phylum->parentId] != NULL);
	genericError(117, globals::ASTEmap[phylum->parentId]->activityTypeName(), globals::ASTEmap[phylum->parentId]->attributes["referenceLine"], ERRORLEVEL_NOTICE);
	P_LinkWrapper2(abstract_phylum, current_view);
	return;
    }


    Place *p1 = PN.newPlace(prefix + "initial");
    Place *p2 = PN.newPlace(prefix + "final");
    Place *p3 = PN.newPlace(prefix + "stop");
    Place *p4 = PN.newPlace(prefix + "stopped");
    Place *p6 = PN.newPlace(prefix + "jc_true");
    Place *p7 = PN.newPlace(prefix + "jc_false");
    Place *p8 = PN.newPlace(prefix + "begin");
    Place *p9 = PN.newPlace(prefix + "faulted");






    PN.mergePlaces(p6, p8);



    Transition *t2 = throwFault(p7, p9, "joinFailure", prefix,
	mkinteger(phylum->parentId),
	globals::ASTEmap[phylum->parentId]->controlFlow);

    PN.newArc(p7, t2);
    PN.newArc(t2, p9);


    dpeLinks(t2, phylum->parentId);


    Transition *t3 = stop(p1, "initial", prefix);
    Transition *t4 = stop(p9, "faulted", prefix);


    P_joinCondition(prefix, phylum->tTarget_list_1, phylum->joinCondition_1);


    PN.mergePlaces(prefix + "begin", newPrefix + ".initial");
    PN.mergePlaces(p2, newPrefix + ".final");
    PN.mergePlaces(p3, newPrefix + ".stop");
    PN.mergePlaces(p4, newPrefix + ".stopped");

#line 376 "petrinet-patterns-links.k"
}
#line  393 "petrinet-patterns-links.cc"

void P_LinkWrapper4(impl_standardElements *abstract_phylum, uview current_view)
#line 407 "petrinet-patterns-links.k"
{
    trace(TRACE_DEBUG, "[PNU]" + inString() + "  wrapper-pattern 4\n");

    impl_standardElements_StandardElements* phylum =
    static_cast<impl_standardElements_StandardElements*>(abstract_phylum);
    assert(phylum != NULL);


    string prefix = toString(phylum->parentId) + ".";
    string newPrefix = toString(phylum->parentId) + ".internal";


    Place *p1 = PN.newPlace(prefix + "initial");
    Place *p2 = PN.newPlace(prefix + "final");
    Place *p5 = PN.newPlace(prefix + "jc_true");
    Place *p6 = PN.newPlace(prefix + "jc_false");
    Place *p7 = PN.newPlace(prefix + "begin");
    Place *p8 = PN.newPlace(prefix + "done");






    PN.mergePlaces(p5, p7);


    Transition *t2 = PN.newTransition(prefix + "skip");

    PN.newArc(p6, t2);
    PN.newArc(t2, p2);


    dpeLinks(t2, phylum->parentId);


    P_transitionCondition(prefix, phylum->tSource_list_1);


    P_joinCondition(prefix, phylum->tTarget_list_1, phylum->joinCondition_1);


    PN.mergePlaces(prefix + "begin", newPrefix + ".initial");
    PN.mergePlaces(p8, newPrefix + ".final"); 


    if (current_view != petrinetsmall_enum)
    {
	Place *p3 = PN.newPlace(prefix + "stop");
	Place *p4 = PN.newPlace(prefix + "stopped");

	Transition *t3 = stop(p1, "initial", prefix);
	Transition *t4 = stop(p2, "final", prefix);

	PN.mergePlaces(p3, newPrefix + ".stop");
	PN.mergePlaces(p4, newPrefix + ".stopped");
    }

#line 464 "petrinet-patterns-links.k"
}
#line  457 "petrinet-patterns-links.cc"

void P_LinkWrapper5(impl_standardElements *abstract_phylum, uview current_view)
#line 496 "petrinet-patterns-links.k"
{
    trace(TRACE_DEBUG, "[PNU]" + inString() + "  wrapper-pattern 5\n");

    impl_standardElements_StandardElements* phylum =
    static_cast<impl_standardElements_StandardElements*>(abstract_phylum);
    assert(phylum != NULL);


    string prefix = toString(phylum->parentId) + ".";
    string newPrefix = toString(phylum->parentId) + ".internal";



    if (petrinetsmall_enum == current_view)
    {
	assert(globals::ASTEmap[phylum->parentId] != NULL);
	genericError(117, globals::ASTEmap[phylum->parentId]->activityTypeName(), globals::ASTEmap[phylum->parentId]->attributes["referenceLine"], ERRORLEVEL_NOTICE);
	P_LinkWrapper4(abstract_phylum, current_view);
	return;
    }


    Place *p1 = PN.newPlace(prefix + "initial");
    Place *p2 = PN.newPlace(prefix + "final");
    Place *p3 = PN.newPlace(prefix + "stop");
    Place *p4 = PN.newPlace(prefix + "stopped");
    Place *p6 = PN.newPlace(prefix + "jc_true");
    Place *p7 = PN.newPlace(prefix + "jc_false");
    Place *p8 = PN.newPlace(prefix + "begin");
    Place *p9 = PN.newPlace(prefix + "done");
    Place *p10 = PN.newPlace(prefix + "faulted");






    PN.mergePlaces(p6, p8);



    Transition *t2 = throwFault(p7, p10, "joinFailure", prefix,
	mkinteger(phylum->parentId),
	globals::ASTEmap[phylum->parentId]->controlFlow);

    PN.newArc(p7, t2);
    PN.newArc(t2, p10);


    dpeLinks(t2, phylum->parentId);


    Transition *t3 = stop(p1, "initial", prefix);
    Transition *t4 = stop(p2, "final", prefix);
    Transition *t5 = stop(p10, "faulted", prefix);


    P_transitionCondition(prefix, phylum->tSource_list_1);


    P_joinCondition(prefix, phylum->tTarget_list_1, phylum->joinCondition_1);


    PN.mergePlaces(prefix + "begin", newPrefix + ".initial");
    PN.mergePlaces(p9, newPrefix + ".final");
    PN.mergePlaces(p3, newPrefix + ".stop");
    PN.mergePlaces(p4, newPrefix + ".stopped");

#line 563 "petrinet-patterns-links.k"
}
#line  531 "petrinet-patterns-links.cc"


} // namespace kc
