// Copyright (C) 2005 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <bayonne.h>
#include <cc++/slog.h>
#include <cc++/socket.h>

#ifdef  WIN32
#define CONFIG_FILES    "C:/Program Files/GNU Telephony/Bayonne Config" 
#define SCRIPT_EXTENSIONS ".bat.cmd.php.py.pl"
#else
#define SCRIPT_EXTENSIONS ".sh.py.pl.php"
#include <private.h>
#endif  

namespace binder {
using namespace ost;
using namespace std;

class Binder : public BayonneBinder, ScriptChecks
{
private:
        void attach(ScriptInterp *interp);
        void detach(ScriptInterp *interp);
	bool select(ScriptInterp *interp);
        bool reload(ScriptCompiler *img);
	Name *service(ScriptImage *img, ScriptInterp *interp, const char *sid);
	void down(void);

public:
        Binder();

        static Binder troll;
}; 

class Checks : public ScriptChecks, public Bayonne
{
public:
        const char *chkAccept(Line *line, ScriptImage *img); 
        const char *chkCDR(Line *line, ScriptImage *img);
        const char *chkRegister(Line *line, ScriptImage *img);  
};

class Methods : public BayonneSession
{
public:
	bool scrAccept(void);
};

} // namespace

	
