#! /bin/sh
# Copyright (C) 2011-2021 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

# Check that the developer can extend the site.exp generated by the
# automake-generated Makefile.

required=runtest
. test-init.sh

write_check_for ()
{
  echo "send_user \"$1: \$$1\\n\""
  unindent << END
    if { \$$1 == "/$1/" } {
        pass "test_$1"
    } else {
        fail "test_$1"
    }
END
}

cat >> configure.ac << 'END'
AC_CONFIG_FILES([testsuite/Makefile])
AC_OUTPUT
END

cat > Makefile.am << 'END'
SUBDIRS = testsuite
END

mkdir testsuite

cat > testsuite/Makefile.am << 'END'
AUTOMAKE_OPTIONS = dejagnu
DEJATOOL = tool

EXTRA_DIST = tool.test/tool.exp

EXTRA_DEJAGNU_SITE_CONFIG = foo.exp
EXTRA_DIST += foo.exp
END

echo 'set foo "/foo/"' > testsuite/foo.exp

mkdir testsuite/tool.test
write_check_for foo > testsuite/tool.test/tool.exp
cat testsuite/tool.test/tool.exp

$ACLOCAL
$AUTOCONF
$AUTOMAKE --add-missing

./configure

$MAKE check
cat testsuite/foo.exp
cat testsuite/site.exp
grep 'PASS: test_foo' testsuite/tool.sum

write_check_for bar >> testsuite/tool.test/tool.exp
write_check_for baz >> testsuite/tool.test/tool.exp
cat testsuite/tool.test/tool.exp

# Ensure that foo.exp will be newer than site.exp, which will
# thus have to be remade.
$sleep
# With this, below we'll also check that settings in files coming later in
# $(EXTRA_DEJAGNU_SITE_CONFIG) override those in files coming earlier.
cat >> testsuite/foo.exp <<'END'
set bar "/foo/"
set baz "/foo/"
set qux "/foo/"
END

$MAKE check && { cat testsuite/site.exp; exit 1; }
grep 'PASS: test_foo' testsuite/tool.sum
grep 'FAIL: test_bar' testsuite/tool.sum
grep 'FAIL: test_baz' testsuite/tool.sum

cat >> testsuite/Makefile.am << 'END'
EXTRA_DEJAGNU_SITE_CONFIG += bar bar.dir/bar
EXTRA_DIST += bar
DISTCLEANFILES = bar.dir/bar
bar.dir/bar:
	test -d bar.dir || mkdir bar.dir
	echo 'set baz "/baz/"' > $@
END

echo 'set bar "/bar/"' > testsuite/bar
# This will allow us to check one more time that settings in files
# coming later in $(EXTRA_DEJAGNU_SITE_CONFIG) override those in
# files coming earlier.
echo 'set baz "/xyz/"' >> testsuite/bar

# Ensure that the Makefile will be newer than site.exp, which will
# thus have to be remade.
$sleep
$AUTOMAKE testsuite/Makefile
./config.status testsuite/Makefile

$MAKE check || { cat testsuite/site.exp; exit 1; }
cat testsuite/site.exp
cat testsuite/bar.dir/bar
$FGREP '/bar/' testsuite/site.exp
$FGREP '/baz/' testsuite/site.exp
grep 'PASS: test_foo' testsuite/tool.sum
grep 'PASS: test_bar' testsuite/tool.sum
grep 'PASS: test_baz' testsuite/tool.sum

# Check that the features we're testing behave well in VPATH builds.
$MAKE distcheck

# Check that the user can edit the site.exp file, and that his edits
# are retained.
write_check_for zardoz >> testsuite/tool.test/tool.exp
cat testsuite/tool.test/tool.exp
echo 'set zardoz "/zardoz/"' >> testsuite/site.exp

$MAKE check
cat testsuite/site.exp
grep 'PASS: test_zardoz' testsuite/tool.sum

cat >> testsuite/Makefile.am << 'END'
EXTRA_DEJAGNU_SITE_CONFIG += quux.exp
quux.exp:
	echo 'set zardoz "/quux/"' > $@
END

# Ensure that the Makefile will be newer than on site.exp, which will
# thus have to be remade.
$sleep
$AUTOMAKE testsuite/Makefile
./config.status testsuite/Makefile
grep 'zardoz.*/quux/' testsuite/Makefile

(cd testsuite/ && $MAKE site.exp)
cat testsuite/site.exp
cat testsuite/quux.exp
grep 'zardoz.*/quux/' testsuite/site.exp

$MAKE check
grep 'PASS: test_zardoz' testsuite/tool.sum
grep 'zardoz: /zardoz/' testsuite/tool.log
grep 'zardoz.*quux' testsuite/tool.log && exit 1

# Check that files in $(EXTRA_DEJAGNU_SITE_CONFIG) are not distributed
# by default.
$MAKE distdir
ls -l $distdir
test ! -e $distdir/testsuite/bar.dir/bar
test ! -e $distdir/testsuite/quux.exp

:
