/*
     This file is part of anastasis-gtk.
     Copyright (C) 2020 Anastasis SARL

     Anastasis is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 3, or (at your
     option) any later version.

     Anastasis is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with Anastasis; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
     Boston, MA 02110-1301, USA.
*/
/**
 * @file src/anastasis/anastasis-gtk_attributes.h
 * @brief
 * @author Christian Grothoff
 * @author Dennis Neufeld
 */
#ifndef ANASTASIS_GTK_ATTRIBUTES_H
#define ANASTASIS_GTK_ATTRIBUTES_H

#include <jansson.h>
#include <gtk/gtk.h>

/**
 * Tries to compile the user's attributes into a JSON object.
 *
 * @param partial is partial collection OK?
 * @return NULL on failure
 */
json_t *
AG_collect_attributes (bool partial);


/**
 * Set widget @a w value from a the @a value.
 *
 * @param w a widget to initialize
 * @param type the attribute type of the widget and the value
 * @param value the value to restore to the widget @a w
 */
void
AG_import_attribute_data (GtkWidget *w,
                          const char *type,
                          const json_t *value);


#endif
