/*
 * ssheet.c
 *
 * definition of the languages style sheets
 * Copyright (c) 1988, 89, 90, 91, 92, 93 Miguel Santana
 * Copyright (c) 1995, 96, 97, 98, 99 Akim Demaille, Miguel Santana
 * $Id: versions.c,v 1.4 1998/03/03 15:52:23 demaille Exp $
 */

/*
 * This file is part of a2ps.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "a2ps.h"
#include "versions.h"
#include "quotearg.h"

/************************************************************************/
/*	The version handling						*/
/************************************************************************/
void
version_set_to_null (int version [4])
{
  int n;

  for (n = 0 ; n < 4 ; n++)
    version[n] = 0;
}

static inline int
_version_is_null (int version [4])
{
  return ((version [0] == 0)
	  && (version [1] == 0)
	  && (version [2] == 0)
	  && (version [3] == 0));
}

int
version_is_null (int version [4])
{
  return _version_is_null (version);
}

int
version_cmp (int v1[4], int v2[4])
{
  int n;

  for (n = 0 ; n < 4 ; n++)
    if (v1[n] < v2[n])
      return -1;
    else if (v1[n] > v2[n])
      return 1;

  return 0;
}

void
version_cpy (int d[4], int s[4])
{
  memcpy (d, s, 4 * sizeof(s[0]));
}

void
version_self_print (int version [4], FILE * stream)
{
  if (version [3])
    fprintf (stream, "%d.%d.%d%c",
	     version [0], version [1], version [2], version [3] + 'a');
  else if (version [2])
    fprintf (stream, "%d.%d.%d",
	     version [0], version [1], version [2]);
  else
    fprintf (stream, "%d.%d",
	     version [0], version [1]);
}

/*
 * Return the length occupied by this version number once printed
 */
int
version_length (int version [4])
{
#define short_int_len(_i_) ((_i_) < 10 ? 1 : 2)
  if (version [3])
    return 2
      + short_int_len(version [0])
      + short_int_len(version [1])
      + short_int_len(version [2])
      + 1;
  else if (version [2])
    return 2
      + short_int_len(version [0])
      + short_int_len(version [1])
      + short_int_len(version [2]);
  else
    return 1
      + short_int_len(version [0])
      + short_int_len(version [1]);
}

void
version_add (int v1[4], int v2[4])
{
  int n;

  for (n = 0 ; n < 4 ; n++)
    v1 [n] += v2 [n];
}

/*
 * Valid versions numbers are:
 * digit.digit
 * digit.digit.digit
 * digit.digit.digitchar
 */
void
string_to_version (const char * version_string, int version [4])
{
  char d;

  switch (sscanf (version_string, "%d.%d.%d%c",
		  &(version[0]), &(version[1]), &(version[2]), &d))
    {
    case 2:
      version[2] = 0;
      /* FALLTHRU */
    case 3:
      version[3] = 0;
      /* Nothing */
      break;
    case 4:
      version[3] = d - 'a' + 1;
      break;
    default:
      error (1, 0,
	     _("invalid version number `%s'"), quotearg (version_string));
      break;
    };
}
