/*
 *	Copyright 1990 by Rayan S. Zachariassen, all rights reserved.
 *	This will be free software, but only when it is finished.
 */

#include <stdio.h>
#ifdef STDARG_H
#include <stdarg.h>
#else
#include <varargs.h>
#endif

/* called as vcall(builtin, argc, argv[0], argv[1], ...) */

int
#ifdef STDARG_H
vcall(int (*func)(), ...)
#else
vcall(va_alist)	
	va_dcl
#endif
{
	int argc, i;
	char *argv[100];		/* XXX */
	va_list ap;

#ifdef STDARG_H
	va_start(ap, func);
#else
	int (*func)();
	va_start(ap);
	func = va_arg(ap, int (*)());
#endif
	argc = va_arg(ap, int);
	for (i = 0; i < argc; ++i)
		argv[i++] = va_arg(ap, char *);
	va_end(ap);
	argv[i] = NULL;
	return (*func)(argc, argv);
}
