.\"
$XMCOPY
.\" Copyright ([\d,\s]*) by Hewlett-Packard Company, Ardent Computer, 
.\" 
.\" Permission to use, copy, modify, distribute, and sell this documentation 
.\" for any purpose and without fee is hereby granted, provided that the above
.\" copyright notice and this permission notice appear in all copies.
.\" Ardent, and Hewlett-Packard make no representations about the 
.\" suitability for any purpose of the information in this document.  It is 
.\" provided \`\`as is'' without express or implied warranty.
.\" 
.\" $XConsortium: XQueryDv.man,v 1.4 94/04/17 20:07:39 dpw Exp $
.ds xL Programming with Xlib
.TH XQueryDeviceState 3X11 "Release 6" "X Version 11" "X FUNCTIONS"
.SH NAME
XQueryDeviceState \- query the state of an extension input device.
.SH SYNTAX
XQueryDeviceState\^(\^\fIdisplay\fP, \fIdevice\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      XDevice *\fIdevice\fP\^; 
.SH ARGUMENTS
.TP 12
.I display
Specifies the connection to the X server.
.TP 12
.I device
Specifies the device whose state is to be queried.
.SH DESCRIPTION
The
\fIXQueryDeviceState\fP
request queries the state of an input device.  The current state of 
keys and buttons (up or down), and valuators (current value) on the device 
is reported by this request.  Each key or button is represented by a bit
in the \fIXDeviceState\fP structure that is returned.  Valuators on the 
device report 0 if they are reporting relative information, and the
current value if they are reporting absolute information.
.P
\fIXQueryDeviceState\fP
can generate a \fIBadDevice\fP error.
.SH STRUCTURES
The
\fIXDeviceState\fP
structure contains:
.P
.nf
typedef struct {
	XID device_id;
	int num_classes;
	XInputClass *data;
} XDeviceState;
.fi
.P
The
\fIXValuatorState\fP
structure contains:
.P
.nf
typedef struct {
	unsigned char class;
	unsigned char length;
	unsigned char num_valuators;
	unsigned char mode;
	int *valuators;
} XValuatorState;
.fi
.P
The \fIXKeyState\fP structure contains:
.P
.nf
typedef struct {
	unsigned char class;
	unsigned char length;
	short         num_keys;
	char keys[32];
} XKeyState;
.fi
.P
The \fIXButtonState\fP structure contains:
.P
.nf
typedef struct {
	unsigned char class;
	unsigned char length;
	short         num_buttons;
	char buttons[32];
} XButtonState;
.fi
.SH DIAGNOSTICS
.TP 12
\fIBadDevice\fP
An invalid device was specified.  The specified device does not exist or has 
not been opened by this client via \fIXOpenInputDevice\fP.  This error may
also occur if some other client has caused the specified device to become
the X keyboard or X pointer device via the \fIXChangeKeyboardDevice\fP or
\fIXChangePointerDevice\fP requests.
.SH "SEE ALSO"
.br
\fI\*(xL\fP
