/* xkeycaps, Copyright (c) 1991, 1992, 1993 Jamie Zawinski <jwz@lucid.com>
 *
 * This file describes the default keymap of the Apple Extended Keyboard II.
 * By John Knox <johnx@exlog.com> and Chris Jones, Baker Hughes
 * Inteq DEAP Support, Aberdeen.
 */

static struct default_keycode_map mac_map [] = {

  /* these have keycodes but no keysyms in the default map */
  { 121, 0,		0 },	/* Pause */
  { 143, 0,		0 },	/* SS (\247) */


  {   8, 0,		XK_A },
  {   9, 0,		XK_S },
  {  10, 0,		XK_D },
  {  11, 0,		XK_F },
  {  12, 0,		XK_H },
  {  13, 0,		XK_G },
  {  14, 0,		XK_Z },
  {  15, 0,		XK_X },
  {  16, 0,		XK_C },
  {  17, 0,		XK_V },
  {  19, 0,		XK_B },
  {  20, 0,		XK_Q },
  {  21, 0,		XK_W },
  {  22, 0,		XK_E },
  {  23, 0,		XK_R },
  {  24, 0,		XK_Y },
  {  25, 0,		XK_T },
  {  26, 0,		XK_1,	XK_exclam },
  {  27, 0,		XK_2,	XK_at },
  {  28, 0,		XK_3,	XK_numbersign },
  {  29, 0,		XK_4,	XK_dollar },
  {  30, 0,		XK_6,	XK_asciicircum },
  {  31, 0,		XK_5,	XK_percent },
  {  32, 0,		XK_equal,	XK_plus },
  {  33, 0,		XK_9,	XK_parenleft },
  {  34, 0,		XK_7,	XK_ampersand },
  {  35, 0,		XK_minus,	XK_underscore },
  {  36, 0,		XK_8,	XK_asterisk },
  {  37, 0,		XK_0,	XK_parenright },
  {  38, 0,		XK_bracketright,	XK_braceright },
  {  39, 0,		XK_O },
  {  40, 0,		XK_U },
  {  41, 0,		XK_bracketleft,	XK_braceleft },
  {  42, 0,		XK_I },
  {  43, 0,		XK_P },
  {  44, 0,		XK_Return },
  {  45, 0,		XK_L },
  {  46, 0,		XK_J },
  {  47, 0,		XK_apostrophe,	XK_quotedbl },
  {  48, 0,		XK_K },
  {  49, 0,		XK_semicolon,	XK_colon },
  {  50, 0,		XK_backslash,	XK_bar },
  {  51, 0,		XK_comma,	XK_less },
  {  52, 0,		XK_slash,	XK_question },
  {  53, 0,		XK_N },
  {  54, 0,		XK_M },
  {  55, 0,		XK_period,	XK_greater },
  {  56, 0,		XK_Tab },
  {  57, 0,		XK_space },
  {  58, 0,		XK_backslash,	XK_asciitilde },
  {  59, 0,		XK_BackSpace },
  {  61, 0,		XK_Escape },
  {  64, ShiftMask,	XK_Shift_L },
/*  {  64, ShiftMask,	XK_Shift_R }, */
  {  65, LockMask,	XK_Caps_Lock },
  {  67, ControlMask,	XK_Control_L },
/*  {  67, ControlMask,	XK_Control_R }, */
  {  73, 0,		XK_KP_Decimal },
  {  75, 0,		XK_KP_Multiply },
  {  77, 0,		XK_KP_Add },
  {  79, Mod5Mask,	XK_Num_Lock },
  {  83, 0,		XK_KP_Divide },
  {  84, 0,		XK_KP_Enter },
  {  86, 0,		XK_KP_Subtract },
  {  89, 0,		XK_KP_Equal },
  {  90, 0,		XK_KP_0 },
  {  91, 0,		XK_KP_1 },
  {  92, 0,		XK_KP_2 },
  {  93, 0,		XK_KP_3 },
  {  94, 0,		XK_KP_4 },
  {  95, 0,		XK_KP_5 },
  {  96, 0,		XK_KP_6 },
  {  97, 0,		XK_KP_7 },
  {  99, 0,		XK_KP_8 },
  { 100, 0,		XK_KP_9 },
  { 104, 0,		XK_F5 },
  { 105, 0,		XK_F6 },
  { 106, 0,		XK_F7 },
  { 107, 0,		XK_F3 },
  { 108, 0,		XK_F8 },
  { 109, 0,		XK_F9 },
  { 111, 0,		XK_F11 },
  { 113, 0,		XK_Print },
  { 115, 0,		XK_Scroll_Lock },
  { 117, 0,		XK_F10 },
  { 119, 0,		XK_F12 },
  { 122, 0,		XK_Insert },
  { 123, 0,		XK_Home },
  { 124, 0,		XK_Prior },
  { 125, 0,		XK_Delete },
  { 126, 0,		XK_F4 },
  { 127, 0,		XK_End },
  { 128, 0,		XK_F2 },
  { 129, 0,		XK_Next },
  { 130, 0,		XK_F1 },
  { 131, 0,		XK_Left },
  { 132, 0,		XK_Right },
  { 133, 0,		XK_Down },
  { 134, 0,		XK_Up }
  };
