/* $SonyId: SjTohanzen.c,v 1.1 1994/05/30 13:03:58 makoto Exp $ */
/******************************************************************

Copyright (c) 1992, 1993, 1994  Sony Corporation

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL SONY CORPORATION BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of Sony Corporation shall
not be used in advertising or otherwise to promote the sale, use or ot
her dealings in this Software without prior written authorization from
Sony Corporation.

******************************************************************/
#include	<ctype.h>
#include	"sjxa.h"
#include	"SjString.h"

static
unsigned short hanzen_euc[] = {
/*20*/	0xa1a1,	0xa1aa,	0xa1c9,	0xa1f4,	0xa1f0,	0xa1f3,	0xa1f5,	0xa1c7,
	0xa1ca,	0xa1cb,	0xa1f6,	0xa1dc,	0xa1a4,	0xa1dd,	0xa1a5,	0xa1bf,
/*30*/	0xa3b0,	0xa3b1,	0xa3b2,	0xa3b3,	0xa3b4,	0xa3b5,	0xa3b6,	0xa3b7,
	0xa3b8,	0xa3b9,	0xa1a7,	0xa1a8,	0xa1e3,	0xa1e1,	0xa1e4,	0xa1a9,
/*40*/	0xa1f7,	0xa3c1,	0xa3c2,	0xa3c3,	0xa3c4,	0xa3c5,	0xa3c6,	0xa3c7,
	0xa3c8,	0xa3c9,	0xa3ca,	0xa3cb,	0xa3cc,	0xa3cd,	0xa3ce,	0xa3cf,
/*50*/	0xa3d0,	0xa3d1,	0xa3d2,	0xa3d3,	0xa3d4,	0xa3d5,	0xa3d6,	0xa3d7,
	0xa3d8,	0xa3d9,	0xa3da,	0xa1ce,	0xa1ef,	0xa1cf,	0xa1b0,	0xa1b2,
/*60*/	0xa1c6,	0xa3e1,	0xa3e2,	0xa3e3,	0xa3e4,	0xa3e5,	0xa3e6,	0xa3e7,
	0xa3e8,	0xa3e9,	0xa3ea,	0xa3eb,	0xa3ec,	0xa3ed,	0xa3ee,	0xa3ef,
/*70*/	0xa3f0,	0xa3f1,	0xa3f2,	0xa3f3,	0xa3f4,	0xa3f5,	0xa3f6,	0xa3f7,
	0xa3f8,	0xa3f9,	0xa3fa,	0xa1d0,	0xa1c3,	0xa1d1,	0xa1b1,
/*a0*/		0xa1a3, 0xa1d6, 0xa1d7, 0xa1a2, 0xa1a6, 0xa5f2, 0xa5a1,
	0xa5a3, 0xa5a5, 0xa5a7, 0xa5a9, 0xa5e3, 0xa5e5, 0xa5e7, 0xa5c3,
/*b0*/	0xa1bc, 0xa5a2, 0xa5a4, 0xa5a6, 0xa5a8, 0xa5aa, 0xa5ab, 0xa5ad,
	0xa5af, 0xa5b1, 0xa5b3, 0xa5b5, 0xa5b7, 0xa5b9, 0xa5bb, 0xa5bd,
/*c0*/	0xa5bf, 0xa5c1, 0xa5c4, 0xa5c6, 0xa5c8, 0xa5ca, 0xa5cb, 0xa5cc,
	0xa5cd, 0xa5ce, 0xa5cf, 0xa5d2, 0xa5d5, 0xa5d8, 0xa5db, 0xa5de,
/*d0*/	0xa5df, 0xa5e0, 0xa5e1, 0xa5e2, 0xa5e4, 0xa5e6, 0xa5e8, 0xa5e9,
	0xa5ea, 0xa5eb, 0xa5ec, 0xa5ed, 0xa5ef, 0xa5f3, 0xa1ab, 0xa1ac,
	0
};

static
unsigned short hanzen_sjis[] = {
/*20*/	0x8140, 0x8149, 0x8168, 0x8194, 0x8190, 0x8193, 0x8195, 0x8166,
	0x8169, 0x816a, 0x8196, 0x817b, 0x8143, 0x817c, 0x8144, 0x815e,
/*30*/	0x824f, 0x8250, 0x8251, 0x8252, 0x8253, 0x8254, 0x8255, 0x8256,
	0x8257, 0x8258, 0x8146, 0x8147, 0x8183, 0x8181, 0x8184, 0x8148,
/*40*/	0x8197, 0x8260, 0x8261, 0x8262, 0x8263, 0x8264, 0x8265, 0x8266,
	0x8267, 0x8268, 0x8269, 0x826a, 0x826b, 0x826c, 0x826d, 0x826e,
/*50*/	0x826f, 0x8270, 0x8271, 0x8272, 0x8273, 0x8274, 0x8275, 0x8276,
	0x8277, 0x8278, 0x8279, 0x816d, 0x818f, 0x816e, 0x814f, 0x8151,
/*60*/	0x8165, 0x8281, 0x8282, 0x8283, 0x8284, 0x8285, 0x8286, 0x8287,
	0x8288, 0x8289, 0x828a, 0x828b, 0x828c, 0x828d, 0x828e, 0x828f,
/*70*/	0x8290, 0x8291, 0x8292, 0x8293, 0x8294, 0x8295, 0x8296, 0x8297,
	0x8298, 0x8299, 0x829a, 0x816f, 0x8162, 0x8170, 0x8150,
/*a0*/		0x8142, 0x8175, 0x8176, 0x8141, 0x8145, 0x8392, 0x8340,
	0x8342, 0x8344, 0x8346, 0x8348, 0x8383, 0x8385, 0x8387, 0x8362,
/*b0*/	0x815b, 0x8341, 0x8343, 0x8345, 0x8347, 0x8349, 0x834a, 0x834c,
	0x834e, 0x8350, 0x8352, 0x8354, 0x8356, 0x8358, 0x835a, 0x835c,
/*c0*/	0x835e, 0x8360, 0x8363, 0x8365, 0x8367, 0x8369, 0x836a, 0x836b,
	0x836c, 0x836d, 0x836e, 0x8371, 0x8374, 0x8377, 0x837a, 0x837d,
/*d0*/	0x837e, 0x8380, 0x8381, 0x8382, 0x8384, 0x8386, 0x8388, 0x8389,
	0x838a, 0x838b, 0x838c, 0x838d, 0x838f, 0x8393, 0x814a, 0x814b,
	0
};

extern LcCtype	user_locale;


unsigned short
#if NeedFunctionPrototypes
hantozen( unsigned short c )
#else
hantozen( c )
    unsigned short	c;
#endif
{
    unsigned char	hi;

    if( user_locale == LC_CTYPE_SHIFTJIS ) {
	if( c < 0x20  ||  (c >= 0x7f && c <= 0xa0)  ||  c >= 0xe0 )
	    return( c );
	return( hanzen_sjis[c - 0x20 - (c > 0xa0)*0x22] );
    }
    else if( user_locale == LC_CTYPE_EUC ) {
	hi = c >> 8;
	if( hi != SS2  &&  hi != 0x00 )
	    return( c );
	c &= 0xff;
	return( hanzen_euc[c - 0x20 - (c > 0xa0)*0x22] );
    }
    else
	return( c );
}


unsigned short
#if NeedFunctionPrototypes
zentohan( unsigned short c )
#else
zentohan( c )
    unsigned short c;
#endif
{
    register unsigned short	*p;

    if( user_locale == LC_CTYPE_SHIFTJIS ) {
	p = hanzen_sjis;
	while( *p != 0 ) {
	    if( c == *p++ ) {
		c = p - (hanzen_sjis + 1) + 0x20;
		if( c > 0x7e )	c += 0x22;
		break;
	    }
	}
    }
    else if( user_locale == LC_CTYPE_EUC ) {
	p = hanzen_euc;
	while( *p != 0 ) {
	    if( c == *p++ ) {
		c = p - (hanzen_euc + 1) + 0x20;
		if( c > 0x7e ) c += (SS2 << 8) | 0x22;
		break;
	    }
	}
    }
    return( c );
}
