USE GsEventLogGathererDB
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[AlertInstance_ins]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
drop trigger [dbo].[AlertInstance_ins]
GO

/*
trigger:	AlertInstance_ins for CDONTS
versions:	1.5
author: 	chriss
date:		12/5/2002
description:	1) get the cursor holding all rows in the inserted table
		2) for every row execute xp_sendmail
Side effects:	sends emails using CDONTS email (doesn't require SQL email)
*/
CREATE TRIGGER [AlertInstance_ins] ON [dbo].[AlertInstance] 
FOR INSERT
AS
	
	DECLARE @object int	-- for CDONTS object
	DECLARE @hr int


	DECLARE @EmailTo VARCHAR(100)
	DECLARE @EmailSubject VARCHAR(255)
	DECLARE @EmailBody VARCHAR(4000)
	
	DECLARE cur2 CURSOR
	FOR
	SELECT
		EmailTo
		,EmailSubject
		,EmailBody
	FROM	inserted
	FOR READ ONLY

	OPEN cur2

	EXEC @hr = sp_OACreate 'CDONTS.NewMail', @object OUT

	FETCH NEXT FROM cur2 INTO @EmailTo, @EmailSubject, @EmailBody
	WHILE @@FETCH_STATUS = 0 BEGIN

		SET @EmailBody = @EmailBody + char(13)	

		EXEC @hr = sp_OASetProperty @object, 'From', 'ELG Alerts<elgalerts@elg_alerts_domain_name.com>'
		EXEC @hr = sp_OASetProperty @object, 'Body', @EmailBody
		EXEC @hr = sp_OASetProperty @object, 'Subject', @EmailSubject
		EXEC @hr = sp_OASetProperty @object, 'To', @EmailTo
		EXEC @hr = sp_OAMethod @object, 'Send', NULL

		FETCH NEXT FROM cur2 INTO @EmailTo, @EmailSubject, @EmailBody
	END
	
	close cur2
	deallocate cur2

GO
