package Twilio::Collection;
use Perlmazing;
use Twilio::Functions;
use overload (
	fallback	=> 1,
	'""'		=> 'SCALAR',
);
our @ISA = qw(Twilio);

sub SCALAR {
	my $self = shift;
	my $pack = caller;
	return $self if $pack =~ /^Twilio(::\w+)*$/;
	if (exists $self->{$self->default_property}) {
		my $ref = ref $self->{$self->default_property};
		my $obj = $self->{$self->default_property};
		unless (($ref eq 'ARRAY' and not @$obj) or ($ref eq 'HASH' and not keys %$obj)) {
			return $self->{$self->default_property};
		}
	}
	ref $self;
}

sub default_property {
	my $self = shift;
	$self->subresource_name;
}

sub default_filter {
	'sid';
}

sub default_create_parameter {
	'friendly_name';
}

sub resource_name () {
	my $self = shift;
	my $name = ref $self;
	substr $name, rindex($name, ':') + 1;
}

sub resource_uri () {
	my $self = shift;
	my $name = ref $self;
	$name = substr $name, rindex($name, ':') + 1;
	$self->account_uri."/$name";
}

sub resource_url {
	my $self = shift;
	$self->root_url.$self->resource_uri;
}

sub subresource_name () {
	my $self = shift;
	my $name = ref $self;
	camel_to_modern(substr $name, rindex($name, ':') + 1);
}

sub subresource_module () {
	my $self = shift;
	my $name = ref $self;
	$name =~ s/s$//;
	$name = substr $name, rindex($name, ':') + 1;
	$self->get_mapping($name);
}

sub new {
	my $class = shift;
	my $self = {
		@_,
	};
	bless $self, $class;
	if (exists $self->{Twilio}) {
		$self->Objects->{Twilio} = delete $self->{Twilio};
	}
	$self->{camel_to_modern($self->subresource_name)} = [];
	my $mod = $self->subresource_module;
	$mod =~ s/::/\//g;
	require "$mod.pm";
	unless (exists $self->{uri}) {
		$self->{uri} = $self->resource_uri;
	}
	$self->die("The property 'uri' is required for this class to work properly") unless not_empty $self->{uri};
	$self->Objects->{subresources} = [];
	$self->classify_subresources;
	$self;
}

sub classify_subresources {
	my $self = shift;
	my $uris = $self->{subresource_uris};
	if ($uris and ref($uris) and ref($uris) eq 'HASH') {
		$uris = { %{$self->{subresource_uris}} };
		for my $res (keys %$uris) {
			my $res_class = $self->get_mapping(modern_to_camel $res);
			eval {
				$self->Objects->{modern_to_camel $res} = $res_class->new (
					Twilio	=> $self->Twilio,
					uri		=> $uris->{$res},
				);
				push @{$self->Objects->{subresources}}, modern_to_camel $res;
			};
			if (my $e = $@) {
				$self->die("While creating ".ref($self)." subresource class:\n$e\nInitial object was:\n".dumped($self)."\n...");
			}
		}
	}
	delete $self->{subresource_uris};
}

sub list {
	my $self = shift;
	my $wantarray = wantarray;
	my $filter;
	if (@_ == 1) {
		$filter = {
			$self->default_filter => shift,
		};
	} elsif (@_ % 2) {
		$self->die("Odd number of elements in arguments");
	} else {
		$filter = {};
		my $tmp = {@_};
		for my $i (keys %$tmp) {
			$filter->{modern_to_camel($i)} = $tmp->{$i};
		}
	}
	@{$self->{$self->subresource_name}} = ();
	my $resource_url = $self->root_url.$self->uri;
	$resource_url =~ s/\.json$//;
	my $tries = 0;
	GET:
	$tries++;
	my $r = $self->Twilio->get("$resource_url.json", {PageSize => 1000, %$filter});
	goto GET unless ref($r) or $tries > 5;
	$self->trace("Looking in response for subresource ".$self->subresource_name);
	unless ($r->{$self->subresource_name} and ref($r->{$self->subresource_name}) and ref($r->{$self->subresource_name}) eq 'ARRAY') {
		$self->trace("Subresource name ".$self->subresource_name." was not found in response!");
		$self->trace("Response: ".dumped($r));
		return;
	}
	$self->trace("There are ".@{$r->{$self->subresource_name}}." elements for ".$self->subresource_name);
	for my $i (@{$r->{$self->subresource_name}}) {
		push @{$self->{$self->subresource_name}}, $i;
	}
	while ($r->{next_page_uri}) {
		$r = $self->Twilio->get($self->get_root_url.$r->{next_page_uri});
		for my $i (@{$r->{$self->subresource_name}}) {
			push @{$self->{$self->subresource_name}}, $i;
		}
	}
	for my $i (@{$self->{$self->subresource_name}}) {
		my $class = $self->subresource_module;
		$i = $class->new(
			Twilio	=> $self->Twilio,
			%$i,
		);
	};
	if ($wantarray) {
		@{$self->{$self->subresource_name}};
	} else {
		if (@{$self->{$self->subresource_name}}) {
			$self->{$self->subresource_name}->[0];
		} else {
			return;
		}
	}
}

sub get {
	my $self = shift;
	my $sid = shift;
	$self->die("Missing 'sid' in arguments") unless $sid;
	my $resource_url = $self->root_url.$self->uri;
	$resource_url =~ s/\.json$//;
	my $r = $self->Twilio->get("$resource_url/$sid.json", {});
	my $class = $self->subresource_module;
	my $uris = delete $r->{subresource_uris};
	$r = $class->new(
		Twilio	=> $self->Twilio,
		%$r,
	);
	if ($uris) {
		for my $res (keys %$uris) {
			my $name = modern_to_camel $res;
			my $res_class = $self->get_mapping($name);
			$r->Objects->{$name} = $res_class->new (
				Twilio	=> $self->Twilio,
				uri		=> $uris->{$res},
			);
			push @{$r->subresources}, modern_to_camel $res;
		}
	}
	$r;
}

sub create {
	my $self = shift;
	my @params;
	if (@_ == 1) {
		push @params, $self->default_create_parameter => shift;
	} elsif (@_ % 2) {
		$self->die("Odd number of elements in arguments");
	} else {
		for (my $i = 0; $i < @_; $i += 2) {
			my $key = modern_to_camel $_[$i];
			if ($key eq 'FriendlyName') {
				$self->die("The friendly name of the new element must not be larger than 64 characters") unless length($_[$i + 1]) <= 64;
			}
			push @params, $key => $_[$i + 1];
		}
	}
	my $url = $self->root_url.$self->uri;
	$url =~ s/\.json$//;
	my $r = $self->Twilio->post("$url.json", \@params);
	my $class = $self->subresource_module;
	$class->new(Twilio => $self->Twilio, %$r);
}

sub resources {
	my $self = shift;
	@{$self->Objects->subresources};
}

1;
