use strict;
use warnings;
use Test::More;
use Parse::Lnk qw(parse_lnk resolve_lnk);
use File::Spec;

my @dirs = File::Spec->splitdir(__FILE__);
pop @dirs;
my $samples_dir_path = File::Spec->catdir(@dirs, 'lnk_samples');

my $data = {
    'shortcut_1.lnk' => {
        attributes         => ["DIRECTORY TARGET"],
        base_path          => "C:\\Windows",
        create_time        => 1575709424.5395,
        error              => undef,
        flags              => [
            "HAS SHELLIDLIST",
            "POINTS TO FILE/DIR",
            "NO DESCRIPTION",
            "NO RELATIVE PATH STRING",
            "HAS WORKING DIRECTORY",
            "NO CMD LINE ARGS",
            "NO CUSTOM ICON",
        ],
        guid               => "0114020000000000c000000000000046",
        hot_key            => 0,
        icon_index         => 0,
        last_accessed_time => 1619239760.19526,
        modified_time      => 1618939654.51834,
        remaining_path     => "",
        show_wnd           => 1,
        show_wnd_flag      => "SW_NORMAL",
        target_length      => 16384,
        target_type        => "local",
        volume_label       => "Workstation",
        volume_serial      => "84e01896",
        volume_type        => "Fixed (Hard Disk)",
        working_directory  => "D:\\etc",
    },
    'shortcut_2.lnk' => {
        attributes         => ["ARCHIVE"],
        base_path          => "C:\\Windows\\notepad.exe",
        create_time        => 1610525895.04632,
        error              => undef,
        flags              => [
            "HAS SHELLIDLIST",
            "POINTS TO FILE/DIR",
            "NO DESCRIPTION",
            "NO RELATIVE PATH STRING",
            "HAS WORKING DIRECTORY",
            "NO CMD LINE ARGS",
            "NO CUSTOM ICON",
        ],
        guid               => "0114020000000000c000000000000046",
        hot_key            => 0,
        icon_index         => 0,
        last_accessed_time => 1619457749.03089,
        modified_time      => 1610525895.04981,
        remaining_path     => "",
        show_wnd           => 1,
        show_wnd_flag      => "SW_NORMAL",
        target_length      => 202240,
        target_type        => "local",
        volume_label       => "Workstation",
        volume_serial      => "84e01896",
        volume_type        => "Fixed (Hard Disk)",
        working_directory  => "C:\\Windows",
    },
    'shortcut_3.lnk' => {
        attributes         => ["HIDDEN TARGET", "SYSTEM FILE TARGET", "DIRECTORY TARGET"],
        base_path          => "\\\\WS1\\G\$",
        create_time        => 1610249161.81747,
        error              => undef,
        flags              => [
            "NO SHELLIDLIST",
            "POINTS TO FILE/DIR",
            "NO DESCRIPTION",
            "NO RELATIVE PATH STRING",
            "NO WORKING DIRECTORY",
            "NO CMD LINE ARGS",
            "NO CUSTOM ICON",
        ],
        guid               => "0114020000000000c000000000000046",
        hot_key            => 0,
        icon_index         => 0,
        last_accessed_time => 1619486909.15056,
        modified_time      => 1619481114.03428,
        remaining_path     => undef,
        show_wnd           => 1,
        show_wnd_flag      => "SW_NORMAL",
        target_length      => 16384,
        target_type        => "network",
    },
    'shortcut_4.lnk' => {
        attributes         => ["DIRECTORY TARGET"],
        base_path          => "\\\\WS1\\KOQ",
        create_time        => 1610257078.13523,
        error              => undef,
        flags              => [
            "NO SHELLIDLIST",
            "POINTS TO FILE/DIR",
            "NO DESCRIPTION",
            "NO RELATIVE PATH STRING",
            "NO WORKING DIRECTORY",
            "NO CMD LINE ARGS",
            "NO CUSTOM ICON",
        ],
        guid               => "0114020000000000c000000000000046",
        hot_key            => 0,
        icon_index         => 0,
        last_accessed_time => 1617683200.68979,
        modified_time      => 1538255194.28168,
        remaining_path     => undef,
        show_wnd           => 1,
        show_wnd_flag      => "SW_NORMAL",
        target_length      => 49152,
        target_type        => "network",
    },
    'shortcut_5.lnk' => {
        attributes         => ["DIRECTORY TARGET"],
        base_path          => "\\\\10.114.42.131\\fzarabozo",
        create_time        => 1619319912.01311,
        error              => undef,
        flags              => [
            "HAS SHELLIDLIST",
            "POINTS TO FILE/DIR",
            "NO DESCRIPTION",
            "NO RELATIVE PATH STRING",
            "NO WORKING DIRECTORY",
            "NO CMD LINE ARGS",
            "NO CUSTOM ICON",
        ],
        guid               => "0114020000000000c000000000000046",
        hot_key            => 0,
        icon_index         => 0,
        last_accessed_time => 1619495386.04843,
        mapped_drive       => "W:",
        modified_time      => 1619319912.01311,
        remaining_path     => "",
        show_wnd           => 1,
        show_wnd_flag      => "SW_NORMAL",
        target_length      => 0,
        target_type        => "network",
    },
};

plan tests => 15;

for my $sample_name (sort keys %$data) {
    my $filename = File::Spec->catfile($samples_dir_path, $sample_name);
    my $parse_pkg = Parse::Lnk->from($filename);
    is_deeply $parse_pkg, $data->{$sample_name}, "Parse::Lnk->from('$filename') returns the expected data";
    my $parse_lnk = parse_lnk $filename;
    is_deeply $parse_lnk, $data->{$sample_name}, "parse_lnk('$filename') returns the expected data";
    my $resolve_lnk = resolve_lnk $filename;
    is $resolve_lnk, $data->{$sample_name}->{base_path}, "resolve_lnk('$filename') returns the expected data";
}

