package BlankOnDev::Migration::bazaar2GitHub;
use strict;
use warnings FATAL => 'all';

# Import Module :
use JSON::XS;
use Term::ReadKey;
use Hash::MultiValue;
use BlankOnDev::Utils::file;
use BlankOnDev::DataDev;
use BlankOnDev::HTTP::request;

# Version :
require BlankOnDev::Version;
our $VERSION = $BlankOnDev::Version::VERSION;

# Subroutine for option "bzr2git" :
# ------------------------------------------------------------------------
sub _bzr2git {
    my ($self, $allconfig) = @_;

    my $options2 = {
        'addpkg' => '_addpkg',
        'addpkg-file' => 'addpkg_file',
        'list-pkg' => '_list_pkg',
        're-branch' => '_bzr_rebranch',
        're-git' => '_git_reupload',
    };

    # Check Argv :
    my $arg_len = scalar @ARGV;
    if ($arg_len > 1) {
        if ($arg_len == 2) {
            if ($allconfig->{'bzr'}->{'url'} eq '' or $allconfig->{'git'}->{'url'} eq '') {
                print "\n";
                print "Warning : \n";
                print "=====" x 16 . "\n";
                print "Please run command \"boidev prepare\" to complete config this application !!! \n\n";
                exit 0;
            } else {

            }
        } else {
            print "\n";
            print "Warning : \n";
            print "=====" x 16 . "\n";
            print "Error: Undefined arguments. You must input two arguments for command [boidev].\n";
            exit 0;
        }
    } else {
        print "\n";
        print "Warning : \n";
        print "=====" x 16 . "\n";
        print "Error : Undefined arguments. You must input arguments for command [boidev].\n";
        $self->usage();
    }
}
# Subroutine for Group Packages :
# ------------------------------------------------------------------------
sub group_pkg {
    my ($self, $allconfig) = @_;

    # Define hash or scalar ;
    my %data = ();
    my $num_pkg_group;
    my $input_pkg_group = '';
    my $pkg_group = '';
    my $pkg_group_stts = 0;
    my $r_pkg_group;

    # Define scalar for group packages :
    my $curr_data_pkg = $allconfig->{'pkg'};
    my $size_datapkg = scalar %{$curr_data_pkg};
    if ($size_datapkg > 0) {
        print "\n";
        print "Choose Group Packages.\n";

        my $num = 0;
        my %num_grp = ();
        while (my ($key, $value) = each %{$curr_data_pkg}) {
            my $_num = $num + 0;
            $num_grp{$num} = $key;
            print "$_num. $key\n";
            $num++;
        }
        chomp($num_pkg_group = <STDIN>);
        if ($num_pkg_group eq '') {
            $pkg_group = '';
            print "\n";
            print "Please Enter name for Group Packages...\n";
        } else {
            if ($num_pkg_group =~ m/^[0-9]+$/) {
                $pkg_group = $num_grp{$num_pkg_group};
                $pkg_group_stts = 2;
            } else {
                print "\n";
                print "Choose Group only Numberic...";
                exit 0;
            }
        }
    } else {
        print "\n";
        print "Enter group name packages before migration.\n";
        chomp($input_pkg_group = <STDIN>);
        if ($input_pkg_group =~ m/^[A-Za-z0-9\-\_]+$/) {
            $pkg_group = $input_pkg_group;
            $r_pkg_group = 1;
            $pkg_group_stts = 1;
        }
        elsif ($input_pkg_group =~ m/^[A-Za-z]+$/) {
            $pkg_group = $input_pkg_group;
            $r_pkg_group = 1;
            $pkg_group_stts = 1;
        }
        else {
            $r_pkg_group = 0;
            $pkg_group = '';
            $pkg_group_stts = 0;
            print "\n";
            print "Name of group package must combination : \n";
            print "- Alphabetic\n";
            print "- Alphabetic Numberic\n";
            print "- Alpabetic Numberic and [_] character or/and [-] character\n";
            print "\n";
            exit 0;
        }
    }

    $data{'result'} = $r_pkg_group;
    $data{'data'} = $pkg_group;
    $data{'status'} = $pkg_group_stts;

    return \%data;
}
# Subroutine for option "addpkg" :
# ------------------------------------------------------------------------
sub _addpkg {
    my ($self, $allconfig) = @_;

    # Define scalar :
    my $new_pkg;

    # For Data Developer :
    my $data_dev = BlankOnDev::DataDev::data_dev();
    my $home_dir = $data_dev->{'home_dir'};
    my $dir_dev = $data_dev->{'dir_dev'};
    my $prefix_flcfg = $data_dev->{'prefix_flcfg'};
    my $file_cfg_ext = $data_dev->{'fileCfg_ext'};
    my $dir_pkgs = $data_dev->{'dir_pkg'};

    # Check Package Group :
    my $pkg_group = $self->group_pkg($allconfig);

    # Get List Command :
    my $list_cmd = list_cmd();

    if ($pkg_group->{result} == 1) {
        # Define scalar for data packages :
        my $input_group = $pkg_group->{'data'};
        my $status_group = $pkg_group->{'status'};
        my $build = $allconfig->{build};
        my $build_rilis = $build->{'rilis'};
        my $data_bzr = $allconfig->{bzr}->{url};
        my $data_git = $allconfig->{git}->{url};
        my $curr_data_pkg = $allconfig->{'pkg'};
        my $locdir_pkg = $dir_dev.$dir_pkgs;
        my $locdir_rilis = $locdir_pkg.'/'.$build_rilis;

        # Check Status group packages :
        if ($status_group == 1) {
            # Define hash or scalar :
            my %data = ();
            my $locdir_pkggroup = $locdir_rilis.'/'.$input_group;
            my $cmd_bzrBranch = $list_cmd->{'bzr'}->{'branch'};

            # Make Dir Group Packages :
            mkdir($locdir_pkggroup);

            print "Enter Packages : ";
            chomp($new_pkg = <STDIN>);
            if ($new_pkg ne '') {
                $data{$input_group} = {
                    $new_pkg => 1
                };
                my $url_repo = $data_bzr.'/'.$new_pkg;
                my $loc_localrepo = $locdir_pkggroup.'/'.$new_pkg;

                # Check Local Repo :
                unless (-d $loc_localrepo) {
                    system("$cmd_bzrBranch $url_repo $loc_localrepo");
                } else {
                    my $for_rebranch = '';
                    print "Repository [$new_pkg] is already exists\n";
                    print "You want to re-branch [y/n] : ";
                    chomp($for_rebranch = <STDIN>);
                    if ($for_rebranch eq 'y' and $for_rebranch eq 'Y') {
                        system("rm -rf $loc_localrepo");
                        system("$cmd_bzrBranch $url_repo $loc_localrepo");
                    }
                    exit 0;
                }
            } else {
                print "Please Enter name package for add !!!\n";
                exit 0;
            }
        }
        elsif ($status_group == 2) {
            # Form Add Package :
            print "Enter New Packages : ";
            chomp($new_pkg = <STDIN>);
            if ($new_pkg ne '') {
                my $locdir_pkggroup = $locdir_rilis.'/'.$input_group;
                my $curr_group = $curr_data_pkg->{$input_group};
                my $add_pkg = Hash::MultiValue->new(%{$curr_group});
                $add_pkg->add($new_pkg => 1);
                my $url_repo = $data_bzr.'/'.$new_pkg;
                my $loc_localrepo = $locdir_pkggroup.'/'.$new_pkg;

                # Check Local Repo :



            } else {
                print "Please Enter name package for add !!!\n";
                exit 0;
            }
        } else {
            print "Please Enter valid name for Group Packages...\n";
            exit 0;
        }
    } else {
        print "Please Enter valid name for Group Packages...\n";
        exit 0;
    }
}

# Subroutine for option "addpkg-file".
# This subroutine functionate to add packages to list from File.
# ------------------------------------------------------------------------
sub _addpkg_file {
    my ($self, $allconfig) = @_;

    # Define scalar :
    my $new_pkg;

    # For Data Developer :
    my $data_dev = BlankOnDev::DataDev::data_dev();
    my $home_dir = $data_dev->{'home_dir'};
    my $dir_dev = $data_dev->{'dir_dev'};
    my $prefix_flcfg = $data_dev->{'prefix_flcfg'};
    my $file_cfg_ext = $data_dev->{'fileCfg_ext'};

    # Check Package Group :
    my $pkg_group = $self->group_pkg($allconfig);

    if ($pkg_group->{result} == 1) {

    } else {
        print "Please Enter valid name for Group Packages...\n";
    }
}
# Subroutine for option "branch" :
# ------------------------------------------------------------------------
sub _branch {
    my ($self, $allconfig) = @_;

    # For Data Developer :
    my $data_dev = BlankOnDev::DataDev::data_dev();
    my $home_dir = $data_dev->{'home_dir'};
    my $dir_dev = $data_dev->{'dir_dev'};
    my $prefix_flcfg = $data_dev->{'prefix_flcfg'};
    my $file_cfg_ext = $data_dev->{'fileCfg_ext'};
}
# Subroutine for option "execute" :
# ------------------------------------------------------------------------
sub _execute {
}
# Subroutine for option "list" :
# ------------------------------------------------------------------------
sub _list {
}
# Subroutine for option "gitcheck :
# ------------------------------------------------------------------------
sub _git_check {
}
# Subroutine for option "help" :
# ------------------------------------------------------------------------
sub usage {
    print "\n";
    print "-----" x 15 . "\n";
    print " For Help Command : \n";
    print "-----" x 15 . "\n";
    print "\n";

    print "USAGE : boidev bzr2git <OPTIONS2>\n";
    BlankOnDev::usage_bzr2git;
#    printf("%-20s %s\n", "config", "Untuk konfigurasi sebelum menggunakan perintah $0");
#    printf("%-20s %s\n", "branch", "Untuk download paket dari Bazaar Server");
#    printf("%-20s %s\n", "listgit", "Untuk melihat daftar paket yang sudah di masukkan ke git");
#    printf("%-20s %s\n", "list", "Untuk melihat daftar paket yang sudah ditambahkan di lokal");
#    printf("%-20s %s\n", "addpkg", "Untuk menambahkan daftar paket yang akan di branch dari Bazaar");
#    printf("%-20s %s\n", "execute", "Untuk melihat daftar paket yang sudah di masukkan ke git");
    print "\n";
    exit 0;
}
# Subroutine for format data Packages :
# ------------------------------------------------------------------------
sub data_format_pkg {
    my %data = (
        ''
    );
    return \%data;
}
# Subroutine for cmd :
# ------------------------------------------------------------------------
sub list_cmd {
    my %data = ();
    $data{'bzr'} = {
        'branch' => 'bzr branch'
    };
    return \%data;
}
# Subroutine for save new configure to file config :
# ------------------------------------------------------------------------
sub save_to_file {
    my ($self, $filename, $dest_dir, $data) = @_;

    my $data_file = encode_json($data);
    my $create_file = BlankOnDev::Utils::file->create($filename, $dest_dir, $data_file);

    return $create_file;

}
1;