package Business::CyberSource::Role::RequestID;
use strict;
use warnings;
use namespace::autoclean;

our $VERSION = '0.005001'; # VERSION

use Moose::Role;

use MooseX::Types::Common::String qw( NonEmptySimpleStr );
use Moose::Util::TypeConstraints;

has request_id => (
	required  => 1,
	predicate => 'has_request_id',
	is        => 'ro',
	isa       => subtype( NonEmptySimpleStr, where { length $_ <= 29 }),
);

1;

# ABSTRACT: Role to apply to requests and responses that require request id's

__END__
=pod

=head1 NAME

Business::CyberSource::Role::RequestID - Role to apply to requests and responses that require request id's

=head1 VERSION

version 0.005001

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
https://github.com/xenoterracide/Business-CyberSource/issues

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Caleb Cushing <xenoterracide@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2011 by Caleb Cushing.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut

