#!/usr/bin/env perl
use 5.012005;
use ExtUtils::MakeMaker;
use ExtUtils::Manifest;
use IPC::Cmd qw/can_run/;
use Carp;

# Since MANIFEST.SKIP(generated by make-manifest-skip.pl) is being ignored by 
# ExtUtils::Manifest::manicheck which checks all files, we replace the 
# manicheck-related functions here.
# (this is for EUMM < 7.02)
*{ExtUtils::Manifest::manicheck}    = sub {};
*{ExtUtils::Manifest::_check_files} = sub {};
$ExtUtils::Manifest::Debug = 1;

## OS check, currently only Linux is supported
if($^O eq "MSWin32") {
    croak "[ERROR] Tsk is not yet supported on Windows\n";
} elsif($^O eq "darwin") {
    croak "[ERROR] Tsk is not yet supported on OS X\n";
} elsif($^O ne "linux") {
    croak "[ERROR] Tsk is not yet supported on $^O";
} else {
    print "Linux OS detected, continuing ... \n";
    ## Check if binaries are available
    for my $bin (qw/autoconf automake libtool libtoolize gcc g++/) {
        croak "[ERROR] $bin not found" if !can_run($bin);
    };
};

## Paths to dependencies
my $SLEUTHKIT_BASE    = "$ENV{PWD}/sleuthkit";
my $SLEUTHKIT_HEADERS = "$SLEUTHKIT_BASE/";
my $SLEUTHKIT_LIBS    = "$SLEUTHKIT_BASE/tsk/.libs";

my $LIBEWF_BASE       = "$ENV{PWD}/libewf";
my $AFFLIB_BASE       = "$ENV{PWD}/AFFLIBv3";
my $AFFLIB_DEPDIR     = "$ENV{PWD}/AFFLIBv3/sandbox";

############################################
# Custom Makefile targets for dependencies #
############################################

sub MY::postamble {
    package MY;
    my $str = <<"MARK1";

libewf/config.status:
	cd $LIBEWF_BASE ; \\
	./configure; \\
	make; \\
	ln -s libewf/.libs lib || true;

AFFLIBv3/config.status:
	cd $AFFLIB_BASE; \\
	./bootstrap.sh; \\
	./configure; \\
	make; \\
        mkdir sandbox; \\
        cd sandbox; \\
	ln -f -s ../lib/* . ; \\
	ln -f -s ../lib/.libs/* . ; \\
        mkdir lib ; \\
        cp ../lib/.libs/* lib/ ; \\
        ln -f -s ../lib/.libs . ; \\
        mkdir include ; \\
        cd include; \\
	ln -f -s ../../lib afflib; \\
        cd ..; \\
        cd ..;

sleuthkit/config.status: AFFLIBv3/config.status libewf/config.status
	echo "sleuthkit_custom runs"; \\
	cd sleuthkit; \\
	./bootstrap;  \\
	./configure --with-libewf=$LIBEWF_BASE --with-afflib=$AFFLIB_DEPDIR;  \\
	make;

custom.sleuthkit: sleuthkit/config.status AFFLIBv3/config.status libewf/config.status

MARK1
    return $str;
};


sub MY::top_targets {
    package MY;
    my $str = shift->SUPER::top_targets(@_);
    $str =~ s/^all :: (.*)/all :: custom.sleuthkit $1/;
    return $str;
};


## make sure that LD_LIBRARY_PATH includes the path to libtsk.so
sub MY::test {
    my $self = shift;
    my $ret = $self->MM::test(@_);
    $ret =~ s/^test\s::\s(.*)$/test :: custom.install $1/xms;
    $ret =~ s{PERL_DL_NONLAZY=1}{PERL_DL_NONLAZY=1 LD_LIBRARY_PATH=./blib/arch/auto/Tsk/}m;
    return $ret;
};


sub MY::install {
    my $self = shift;
    my $str = $self->MM::install(@_);
    $str =~ s/^install\s::\s(.*)$/install :: custom.install $1/xms;
    my $custom_install=<<"MARK2";

custom.install: custom.sleuthkit
	cp $SLEUTHKIT_LIBS/libtsk.so.10.2.0 \$(INST_ARCHAUTODIR)/
	cd \$(INST_ARCHAUTODIR) ; ln -f -s libtsk.so.10.2.0 libtsk.so.10 ; ln -f -s libtsk.so.10  libtsk.so;
	true

MARK2

    $str = "$custom_install $str";
    #print $str;
    return $str;
}

my $CC = "g++";
WriteMakefile(
    INST_ARCHLIB      => './blib/arch',
    INST_LIB          => './blib/lib',
    NAME              => 'Tsk',
    VERSION_FROM      => 'lib/Tsk.pm', 
    LICENSE           => "perl",
    PREREQ_PM         => {}, 
    ($] >= 5.005 ?     
      (ABSTRACT_FROM  => 'lib/Tsk.pm',
       AUTHOR         => 'Stefan Petrea <stefan@garage-coding.com>') : ()),
    #LIBS              => ["-L$SLEUTHKIT_LIBS -L$PBREWPATH -ltsk -lstdc++"], # e.g., '-lm'
    LIBS              => "-lstdc++ -ltsk", # e.g., '-lm'
    #LINKTYPE          => 'static',
    #XSOPT             => "-C++ -nolinenumbers",
    XSOPT             => "-C++",
    DEFINE            => '-DDEBUG', # e.g., '-DHAVE_SOMETHING',
    OPTIMIZE          => '-O0 -g',
    CC                => $CC,
    CCFLAGS           => "-Wall",
    #LDLOADLIBS	      => "-lstdc++",
    LDDLFLAGS 	      => " -Wl,--no-as-needed -shared  -L$SLEUTHKIT_LIBS -ltsk -lstdc++",
    #MYEXTLIB          => "sleuthkit/tsk/.libs/libtsk.so.10",
    #LDDLFLAGS          => "-DDEBUG -O0 -g -shared -Wl,-rpath $SLEUTHKIT_LIBS",
    #LDDLFLAGS          => "-DDEBUG -O0 -g -shared",
    BUILD_REQUIRES    => {
            'ExtUtils::MakeMaker' => 6.48,
            'ExtUtils::XSpp'      => 0.1602,
            'Devel::Symdump'      => 2.11,
            'Digest::MD5'         => 2.53,
            #'Test::LeakTrace'     => 0.14,
            #'Devel::Peek'         => undef,
    },
    NORECURS          => 1,
    XS                => {
        "Main.xs"            => "Main.c",
        "TskFsName.xs"       => "TskFsName.c",
        "TskFsMeta.xs"       => "TskFsMeta.c",
        "TskFsBlock.xs"       => "TskFsBlock.c",
        "TskFsFile.xs"       => "TskFsFile.c",
        "TskFsInfo.xs"       => "TskFsInfo.c",
        "TskFsDir.xs"        => "TskFsDir.c",
        "TskVsInfo.xs"       => "TskVsInfo.c",
        "TskVsPartInfo.xs"   => "TskVsPartInfo.c",
        "TskImgInfo.xs"      => "TskImgInfo.c",
        "TskStack.xs"        => "TskStack.c",
        "TskFsAttribute.xs"  => "TskFsAttribute.c",
    },
    INC               => "-I$SLEUTHKIT_HEADERS -I.", # e.g., '-I. -I/usr/include/other'
    OBJECT            => '$(O_FILES)', 
    dist	      => {
     COMPRESS => 'gzip -9f',
     SUFFIX   => '.gz'
    },
    TYPEMAPS          => ['typemap'],

    ## add rpaths for both the install path and for the current path(for development)
    dynamic_lib => { OTHERLDFLAGS => '-Wl,-rpath,$(INSTALLSITEARCH)/auto/$(FULLEXT) -Wl,-rpath,sleuthkit/tsk/.libs/'},
);


