#!perl
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
#   file: t/templates.t #
#
#   Copyright © 2015 Van de Bugger
#
#   This file is part of perl-Dist-Zilla-Plugin-Templates.
#
#   perl-Dist-Zilla-Plugin-Templates is free software: you can redistribute it and/or modify it
#   under the terms of the GNU General Public License as published by the Free Software Foundation,
#   either version 3 of the License, or (at your option) any later version.
#
#   perl-Dist-Zilla-Plugin-Templates is distributed in the hope that it will be useful, but WITHOUT
#   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#   PURPOSE. See the GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along with
#   perl-Dist-Zilla-Plugin-Templates. If not, see <http://www.gnu.org/licenses/>.
#
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

use strict;
use warnings;
use lib 't';

use Test::More;
use Test::Routine::Util;
use Test::Deep qw{ re };

# `AutoPrereqs` hints:
use Dist::Zilla::Plugin::Hook 0.004 ();     # v0.004 works with Perl pre-5.14.

plan tests => 3;

my $role  = 'TemplatesTester';
my $abort = 'Dist::Zilla died in construction: Aborting...';

my @vars = (
    [ 'Hook::Init', {
        'hook' => [
            '$MY::name    = "Assa";',
            '$MY::package = "Assa";',
            '$MY::version = "0.007";',
        ],
    } ],
);
my @files = (
    [ 'GenerateFile', 'README', {
        'filename' => 'README',
        'content'  => [
            '{{$MY::name}} is an example of...',
        ],
    } ],
    [ 'GenerateFile', 'lib/Assa.pm', {
        'filename' => 'lib/Assa.pm',
        'content'  => [
            'package {{$MY::package}};',
            '# ABSTRACT: Yoohoo',
            '1;',
        ],
    } ],
    [ 'GenerateFile', 'lib/Assa/Manual.pod', {
        'filename' => 'lib/Assa/Manual.pod',
        'content'  => [
            '=head1 NAME',
            '',
            '{{$name}} - Err... Aahh...',       # Note: `$name`, not `$MY::name`.
            '/* $version */',
            '',
            '=cut',
        ],
    } ],
);

run_tests( 'InstallModules', $role, {
    ini_body => [
        @vars,
        @files,
        [ 'Templates', {
            'templates' => ':InstallModules',
        } ],
    ],
    exp_messages => [
    ],
    exp_files => {
        'README' => [
            '{{$MY::name}} is an example of...',
            #^^^^^^^^^^^^^ Not replaced because not an install module.
        ],
        'lib/Assa.pm' => [
            'package Assa;',
            #        ^^^^ Replaced.
            '# ABSTRACT: Yoohoo',
            '1;',
        ],
        'lib/Assa/Manual.pod' => [
            '=head1 NAME',
            '',
            ' - Err... Aahh...',
            #^^^ Replaced with empty string: there is no variable `$name`.
            '/* $version */',
            '',
            '=cut',
        ],
    },
} );

run_tests( 'AllFiles', $role, {
    ini_body => [
        @vars,
        @files,
        [ 'Templates', {
            'package' => 'MY',
            'prepend' => '$MY::name = "hohoho";',   # Note: We change the variable value
            'templates' => [
                ':AllFiles',
            ],
        } ],
    ],
    exp_messages => [
    ],
    exp_files => {
        'README' => [
            'hohoho is an example of...',
            #^^^^^^ Replaced, not `Assa` because of `prepend` effect.
        ],
        'lib/Assa.pm' => [
            'package Assa;',
            #        ^^^^ Replaced.
            '# ABSTRACT: Yoohoo',
            '1;',
        ],
        'lib/Assa/Manual.pod' => [
            '=head1 NAME',
            '',
            'hohoho - Err... Aahh...',
            #^^^^^^ Replaced because of `MY` package context (and `prepend` effect).
            '/* $version */',
            '',
            '=cut',
        ],
    },
} );

run_tests( 'Non-standard delimiters', $role, {
    ini_body => [
        @vars,
        @files,
        [ 'Templates', {
            'delimiters' => '/* */',
            'package'    => 'MY',
            'templates' => [
                ':AllFiles',
            ],
        } ],
    ],
    exp_messages => [
    ],
    exp_files => {
        'README' => [
            '{{$MY::name}} is an example of...',
            #^^^^^^^^^^^^^ Not replaced.
        ],
        'lib/Assa.pm' => [
            'package {{$MY::package}};',
            #        ^^^^^^^^^^^^^^^^ Not replaced.
            '# ABSTRACT: Yoohoo',
            '1;',
        ],
        'lib/Assa/Manual.pod' => [
            '=head1 NAME',
            '',
            '{{$name}} - Err... Aahh...',
            #^^^^^^^^^ Not replaced.
            '0.007',
            #^^^^^ Replaced.
            '',
            '=cut',
        ],
    },
} );

done_testing;

exit( 0 );

# end of file #
