#!perl
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
#   file: xt/synopsis.t
#
#   Copyright © 2015 Van de Bugger
#
#   This file is part of perl-Dist-Zilla-Plugin-Manifest-Write.
#
#   perl-Dist-Zilla-Plugin-Manifest-Write is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by the Free Software
#   Foundation, either version 3 of the License, or (at your option) any later version.
#
#   perl-Dist-Zilla-Plugin-Manifest-Write is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
#   PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along with
#   perl-Dist-Zilla-Plugin-Manifest-Write. If not, see <http://www.gnu.org/licenses/>.
#
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

use strict;
use warnings;
use lib 't';
use lib 'ex';

use Test::More;
use Test::Routine::Util;
use ManifestWriteTester;

plan tests => 1;

my $role = 'ManifestWriteTester';

#   Use plugin from the main module synopsis.
run_tests( 'Synopsis', $role, {
    writer => 'Manifest::Write::FileSize',
    plugins => [
        'GatherDir',
        [ 'Manifest::Write::FileSize', { source_providers => 'GatherDir' } ],
        #                 ^^^^^^^^^^
    ],
    expected => {
        manifest => [
            'MANIFEST     #  metainfo file built by Manifest::Write',
            'dist.ini     #     Dummy file added by GatherDir (212 bytes)',
            #                                                ^^^^^^^^^^^^
            'lib/Dummy.pm #     Dummy file added by GatherDir (20 bytes)',
            #                                                ^^^^^^^^^^^
        ],
    },
} );

done_testing;

exit( 0 );

# end of file #
