# $Id$

# use 5.008;
use ExtUtils::MakeMaker;
use ExtUtils::PkgConfig;
use Getopt::Long;

my $rpmv;
GetOptions(
    'rpmversion=s' => \$rpmv,
    'rebuildh' => \my $rebh,
);

my $rpmheaderlocation;

foreach (qw(
    /usr/include
    /usr/local/include
    )) {
    if (-d "$_/rpm") {
        $rpmheaderlocation = "$_/rpm";
        last;
    }
}

$rpmheaderlocation or die "Can't find rpmheader location";

my %cfg = ExtUtils::PkgConfig->find("rpm");
$rpmv ||= $cfg{modversion};
open(my $FH, "> rpmversion.h") or die "Can't open rpmversion.h";
print $FH "/* File generated by Makefile.PL\n";
print $FH ' * $Id$' . "\n";
print $FH " */\n\n";
print $FH "#ifndef RPMVERSION_H\n#define RPMVERSION_H\n\n";
foreach (qw(
    4.12.90
    4.15.0
    )) {
    my $v = $_;
    $rpmv < $v and last;
    $v =~ s/\./_/g;
    print $FH "#define RPM$v\n";
    $rpmv =~ /^\Q$_/ and last;
}
# Special case for patched rpm-4.12 in Mageia 5 & Fedora, 4.11 & 4.12 in Debian:
sub cat_ { my @l = map { my $F; open($F, '<', $_) ? <$F> : () } @_; wantarray() ? @l : join '', @l }
if (grep { /int rpmPkgSign.*rpmSignArgs/ } cat_("$rpmheaderlocation/rpmsign.h")) {
    print $FH "#define PATCHED_rpmPkgSign\n";
}
print $FH "\n#endif\n";
close($FH);
exit 0 if $rebh;

my @rpmconstantfiles = qw(
    rpmconstant.c
    rpmconstant.h
    rpmconstant_internal.c
    rpmh2tbl
    );

my ($obj, $ldd, $fl) =
    -f '/usr/include/rpmconstant/rpmconstant.h' ?
    ('', '-lrpmconstant', '-DHAVE_RPMCONSTANT') :
    ('rpmconstant.o rpmconstant_internal.o rpmconstanttbl.o', '', '');

sub MY::postamble() {
        my $first = <<RPMCONSTTBL;
rpmversion.h:
	\$(PERL) Makefile.PL --rebuildh

rpmconstanttbl.c: Makefile rpmh2tbl
	perl rpmh2tbl $rpmheaderlocation/*.h > \$@

RPMCONSTTBL
	# This code is to reduce duplication of files
	# in fact it is only usefull for the maintainers of this module
	# if you get the module from CPAN, those files are already here
	# if you're building from svn, you need rpmconstant directory
	my $second = "copyrpmconstant: " . join(" ", @rpmconstantfiles) . "\n\n";
	if (-d '../../rpmconstant') {
            foreach (@rpmconstantfiles) {
                $second .= "$_: ../../rpmconstant/$_\n\tcp -a \$< \$@\n\n";
            }
	}

	$first . $second;
}

my $v = $rpmv;
$v =~ s/\./_/g;
WriteMakefile(
    NAME         => 'RPM4',
    VERSION_FROM => '../lib/RPM4.pm',
    OBJECT       => "RPM4.o $obj",
    INC	         => "-I$rpmheaderlocation",
    LIBS         => [ $cfg{libs} . " -lrpmsign -lrpmbuild $ldd" ],
    CCFLAGS      => "$cfg{cflags} -Wall $fl -DRPM$v",
    depend       => { "RPM4.xs" => join(" ", @rpmconstantfiles) },
);
