our $booted = 1;

unlink 'booted';

open my $pidfile, '<', 'boot.pid';
my $pid = <$pidfile>;
close $pidfile;
chomp $pid;

if ( $pid ) {
    print STDERR "kill 'TERM' => $pid;";
    kill 'TERM' => $pid;
    select undef, undef, undef, 1;
    kill 'KILL' => $pid;
    print STDERR "kill 'TERM' => $pid;";

    unlink 'booted';
}

open $pidfile, '>', 'boot.pid';
print $pidfile $$;
close $pidfile;

open *STDOUT, '>', '../boot.log';
open *STDERR, '>', '../boot-err.log';

BEGIN { $ENV{DBI_PUREPERL}=1 }

$SIG{'INT'}  = 'IGNORE';
$SIG{'QUIT'} = 'IGNORE';
$SIG{'TERM'} = 'IGNORE';



my @files = qw{
./jeliza-auto-client.pl
./jeliza-auto-server.pl
./jeliza-batch.pl
./jeliza-cgi-engine.pl
./jeliza-cgi.fcgi
./jeliza-cgi.pl
./jeliza-cgi-simple.pl
./jeliza-console.pl
./jeliza-engine.pl
./jeliza-log.pl
./jeliza.pl
./jeliza-shell.pl
./AI/POS.pm
./AI/SemanticNetwork.pm
./AI/Selector.pm
./jeliza-service-tagger.pl
./perl.exe
./jeliza-proxy.pl
./jeliza-offer.pl
./File/Tee.pm
./lang_de/wsh/arts.wsh
./lang_de/wsh/first_names.wsh
./lang_de/wsh/names.wsh
./lang_de/wsh/no-names.wsh
./lang_de/word_types.memory
./lang_de/word_types.taggerinput
./DBI.pm
./DBI/PurePerl.pm
./DBD/SQLite.pm
./DBD/CSV.pm
SQL/Eval.pm
SQL/Dialects/ANSI.pm
SQL/Dialects/CSV.pm
SQL/Dialects/AnyData.pm
SQL/Parser.pm
SQL/GetInfo.pm
SQL/Functions.pm
SQL/Syntax.pod
SQL/Util.pm
SQL/ANSI.pm
SQL/Statement/GetInfo.pm
SQL/Statement/Functions.pm
SQL/Statement/Syntax.pod
SQL/Statement/Util.pm
SQL/Statement/RAM.pm
SQL/Statement/Structure.pod
SQL/Statement/Embed.pod
SQL/Statement.pm
SQL/RAM.pm
SQL/CSV.pm
SQL/Structure.pod
SQL/Embed.pod
SQL/AnyData.pm
};

my @dirs = qw{
./AI
./File
./lang_de
./lang_de/wsh
./DBD
./Net
./Digest
./MIME
./DBI
SQL/
SQL/Statement/
SQL/Dialects/
};

foreach my $n (0..10) {
    foreach my $dir (@dirs) {
        mkdir $dir;
    }
}

use LWP::Simple;

foreach my $file (@files) {
    if ( ($file =~ /lang|SQL/ || -f 'no-download') && -f $file ) {
        print "NOT downloading ", $file, "\n";
        next;
    }
    
    print "downloading ", $file, "\n";
    $content = get("http://resources.freehal.org/resources/download/".$file.".txt");
    if ( $content ) {
        # print $content;
        open my $file, '>', $file;
        print { $file } $content;
        close $file;
    }
}

print "Download finished.\n";

my $lang = 'lang_de';
my $action = shift;
if ( length($action) == 2 ) {
    $lang = $action;
    $action = shift;
}
else {
    $lang = shift || $lang;
}

print "Actions?.\n";
if ( $action ) {
    opendir( my $dir, '.' );
    foreach my $file (readdir($dir)) {
        next if $file !~ /do[-]/;
        print "deleting ", $file, "\n";
        unlink $file;
    }
    my $file = 'do-'.$action;
    print "creating ", $file, "\n";
    open my $f, '>', $file;
    close $f;
}

print "Languages?.\n";
#select undef, undef, undef, 5;
opendir( my $dir, '.' );
foreach my $may_be_lang (readdir($dir)) {
    next if $may_be_lang !~ /lang_/;
    if (    -f $may_be_lang . '/default'
         || -f $may_be_lang . '/default.txt' ) {
        
        print "Language ", $may_be_lang, " is default.\n";
        $lang = $may_be_lang;
    }
    else {
        print "Language ", $may_be_lang, " is NOT default.\n";
    }
}

#select undef, undef, undef, 5;

$lang =~ s/lang_//igm;

print "So, the default is: $lang\n";

mkdir "temp";
open my $lang_file, ">", "temp/language.tmp";
print $lang_file $lang;
close $lang_file;


open my $file, '>', 'booted';
close $file;

$lang =~ s/lang_//igm;

unshift @ARGV, $lang;

if ( -f 'do-batch' ) {
    require("./jeliza-batch.pl");
}
elsif ( -f 'do-autoserver' ) {
    require("./jeliza-auto-server.pl");
}
elsif ( -f 'do-server' ) {
    require("./jeliza.pl");
}
elsif ( -f 'do-proxy' ) {
    require("./jeliza-proxy.pl");
}
elsif ( -f 'do-shell' ) {
    require("./jeliza-shell.pl");
}

1;