#
# This class is indented to be automatically loaded by Padre::DB,
# overloading the code already auto-generated by Padre::DB.
#

package Padre::DB::SessionFile;

use strict;
use warnings;

our $VERSION = '0.34';

1;

__END__

=pod

=head1 NAME

Padre::DB::SessionFiles - db table keeping files in a given session


=head1 SYNOPSIS

        my @files = Padre::DB::SessionFiles->select(
                'where  session = ?', $session_id
        );



=head1 DESCRIPTION

This class allows storing in Padre's database the files referenced by a
given session (see C<Padre::DB::Session>.



=head1 PUBLIC METHODS

=head2 Accessors

The following accessors are automatically created by C<ORLite>:

=over 4

=item id()

=item file()

=item position()

=item focus()

=item session()

=back


=head2 Class methods

The following subs are automatically created by C<ORLite>. Refer to C<ORLite>
for more information on them:

=over 4

=item select()

=item count()

=item new()

=item create()

=item insert()

=item delete()

=item truncate()

=back



=head1 COPYRIGHT & LICENSE

Copyright 2008-2009 The Padre development team as listed in Padre.pm.

This program is free software; you can redistribute
it and/or modify it under the same terms as Perl itself.

The full text of the license can be found in the
LICENSE file included with this module.

=cut

# Copyright 2008-2009 The Padre development team as listed in Padre.pm.
# LICENSE
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl 5 itself.
