package Padre::Wx::Menu::Search;

# Fully encapsulated Search menu

use 5.008;
use strict;
use warnings;
use Padre::Wx          ();
use Padre::Wx::Submenu ();
use Padre::Current     qw{_CURRENT};

our $VERSION = '0.24';
our @ISA     = 'Padre::Wx::Submenu';





#####################################################################
# Padre::Wx::Submenu Methods

sub new {
	my $class = shift;
	my $main  = shift;

	# Create the empty menu as normal
	my $self = $class->SUPER::new(@_);





	# Search and Replace
	$self->{find} = $self->Append(
		Wx::wxID_FIND,
		Wx::gettext("&Find\tCtrl-F")
	);
	Wx::Event::EVT_MENU( $main,
		$self->{find},
		sub {
			Padre::Wx::Dialog::Find->find(@_)
		},
	);

	$self->{find_next} = $self->Append( -1,
		Wx::gettext("Find Next\tF3")
	);
	Wx::Event::EVT_MENU( $main,
		$self->{find_next},
		sub {
			Padre::Wx::Dialog::Find->find_next(@_);
		},
	);

	$self->{find_previous} = $self->Append( -1,
		Wx::gettext("Find Previous\tShift-F3")
	);
	Wx::Event::EVT_MENU( $main,
		$self->{find_previous},
		sub {
			Padre::Wx::Dialog::Find->find_previous(@_);
		},
	);

	$self->AppendSeparator;

	# Quick Find: Press F3 to start search with selected text
	$self->{quick_find} = $self->AppendCheckItem( -1,
		Wx::gettext("Quick Find")
	);
	Wx::Event::EVT_MENU( $main,
		$self->{quick_find},
		sub {
			Padre->ide->config->{is_quick_find} = $_[1]->IsChecked ? 1 : 0;
			return;
		},
	);
	$self->{quick_find}->Check( Padre->ide->config->{is_quick_find} ? 1 : 0 );

	# Incremental find (#60)
	$self->{quick_find_next} = $self->Append( -1,
		Wx::gettext("Find Next\tF4")
	);
	Wx::Event::EVT_MENU( $main,
		$self->{quick_find_next},
		sub {
			$_[0]->find->search('next');
		},
	);

	$self->{quick_find_previous} = $self->Append( -1,
		Wx::gettext("Find Previous\tShift-F4")
	);
	Wx::Event::EVT_MENU( $main,
		$self->{quick_find_previous},
		sub {
			$_[0]->find->search('previous');
		}
	);

	$self->AppendSeparator;

	Wx::Event::EVT_MENU( $main,
		$self->Append( -1,
			Wx::gettext("Ac&k Search")
		),
		\&Padre::Wx::Ack::on_ack,
	);





	return $self;
}

sub refresh {
	my $self = shift;
	my $doc  = _CURRENT(@_)->document ? 1 : 0;
	$self->{ find                }->Enable($doc);
	$self->{ find_next           }->Enable($doc);
	$self->{ find_previous       }->Enable($doc);
	$self->{ quick_find          }->Enable($doc);
	$self->{ quick_find_next     }->Enable($doc);
	$self->{ quick_find_previous }->Enable($doc);
	return;
}

1;
