use strict;
use warnings;

use lib 'inc';
use Padre::Install;
use Config;

if ( not $Config{usethreads} ) {
	warn "Padre requires a perl built using threads\n";
	exit 0;
}

check_wx_version();

print <<"END_WARN";
**********************************************************
WARNING

We have renamed the MY plugin to be called Padre::Plugin::My 
If you have Padre::Plugin::MY (in capital letters) installed
on your system (it came with 0.17 of Padre) Please remove
it manually before launching Padre.

It can be both in the standard \@INC and in ~/.padre/plugins/

**********************************************************
END_WARN

my %prereqs = (
	'perl'                    => '5.008001',
	'Carp'                    => 0,
	'Class::Adapter'          => '1.05',
	'Class::XSAccessor'       => '0.09',
	'Cwd'                     => '3.2701',
	'Data::Dumper'            => 0,
	'Encode'                  => '2.12',
	'File::Spec'              => '3.2701',
	'File::Spec::Functions'   => '3.2701',
	'File::Basename'          => 0,
	'FindBin'                 => 0,
	'Getopt::Long'            => 0,
	'HTML::Parser'            => '3.58',
	'HTML::Entities'          => '3.57',
	'List::Util'              => '1.18',
	'IO::Socket'              => '1.30',
	'Term::ReadLine'          => 0,
	'Module::Refresh'         => '0.13',
	'App::Ack'                => '1.86',
	'Class::Autouse'          => '1.26',
	'Class::Unload'           => '0.03',
	'DBD::SQLite'             => '1.10',
	'DBI'                     => '1.58',
	'File::Copy::Recursive'   => '0.37',
	'File::Find::Rule'        => '0.30',
	'File::HomeDir'           => '0.82',
#	'File::LocalizeNewlines'  => '1.10',
	'File::ShareDir'          => '1.00',
	'File::ShareDir::PAR'     => '0.03',
	'File::Slurp'             => '9999.13',
	'File::Which'             => '0.05',
	'Module::Inspector'       => '0.04',
	'Module::Starter'         => '1.50',
	'ORLite'                  => '0.15',
	'PAR'                     => '0.970',
	'Pod::POM'                => '0.17',
	'Pod::Simple'             => '3.07',
	'Probe::Perl'             => '0.01',
	'PPI'                     => '1.203',
	'Text::Diff'              => '0.35',
	'Text::FindIndent'        => '0.03',
	'YAML::Tiny'              => '1.32',
	'Wx'                      => '0.86',
	'Wx::Perl::Dialog'        => '0.03',
	'Wx::Perl::ProcessStream' => '0.11',
);



my $builder = Padre::Install->new(
	module_name           => 'Padre',
	license               => 'perl',
	dist_author           => 'Gabor Szabo',
	create_makefile_pl    => 0,
	create_readme         => 0,
	recursive_test_files  => 0,

	script_files          => [ 'script/padre' ],
	requires              => \%prereqs,
	build_requires        => {
#		'Test::Compile'             => '0.08', # does not work on Windows
		'Test::More'                => '0.47',
		'Test::Exception'           => '0.27',
		'Test::NoWarnings'          => '0.084',
		'Test::NeedsDisplay'        => '1.05',
	},
	meta_merge => {
		resources => {
			homepage    => 'http://padre.perlide.org/',
			bugtracker  => 'http://padre.perlide.org/',
			Repository  => 'http://svn.perlide.org/padre',
			MailingList => 'http://mail.perlide.org/mailman/listinfo/padre-dev',
		},
		no_index => {
			directory => [ qw{ t xt eg share inc} ],
		},
	},
);

#use File::Spec::Functions qw(catdir);
#$builder->install_path->{share} = catdir($builder->install_path->{lib}, 'auto', 'share', 'dist', $builder->dist_name);
$builder->config('usethreads');

$builder->create_build_script();



sub check_wx_version {

	eval {require Wx};
	return if $@;  # missing Wx should be dealt by the standard prereq system

	my $version = Wx::wxVERSION_STRING();
	nono("Could not find Wx::wxVERSION_STRING") if not defined $version;

	print "Found $version\n";
	$version =~ s/wxWidgets\s+//;
	nono("Sorry we don't known this wxWidgets version format: '$version'")
		if $version !~ /^\d+\.\d+(\.\d+)?$/;
	my ($major, $minor, $way_too_minor) = split /\./, $version;
	nono("Padre needs at least version 2.8.8 of wxWidgets. this is version $version")
		if $major < 2 or $minor < 8;

	return;
}

sub nono {
	my $msg = shift;
	print STDERR "$msg\n";
	exit 0;
}
