package CPAN::Digger::CLI;
use strict;
use warnings FATAL => 'all';

our $VERSION = '1.02';

use Getopt::Long qw(GetOptions);

use CPAN::Digger;

sub run {
    my %args = (
        report => undef,
        author => undef,
        github => undef,
        recent => undef,
        log    => 'OFF',
        help   => undef,
        sleep  => 0,
        db     => undef,
    );

    GetOptions(
        \%args,
        'author=s',
        'db=s',
        'recent=i',
        'sleep=i',
        'github',
        'log=s',
        'report',
        'help',
    ) or usage();
    usage() if $args{help};
    usage() if not ($args{author} xor $args{recent});

    my $cd = CPAN::Digger->new(%args);
    $cd->collect();
}


sub usage {
    die qq{Usage: $0
    Required exactly one of them:
       --recent N         (Number of the most recent packages to check)
       --author PAUSEID

       --report           (Show text report at the end of processing.)
       --log LEVEL        [ALL, TRACE, DEBUG, INFO, WARN, ERROR, FATAL, OFF] (default is OFF)

       --github           Fetch information from github
       --sleep SECONDS    (Wait time between git clone operations, defaults to 0)

       --db PATH          (path to SQLite database file, if not supplied using in-memory database)

       --help

    Sample usage for authors:
        $0 --author SZABGAB --report --github --sleep 3

    Sample usage in general:
        $0 --recent 30 --report --github --sleep 3

};
}


42;

