use strict;
use warnings;

use Test::More tests => 10;
use Test::Differences;
use Test::Exception;
use Test::NoWarnings;

BEGIN {
    use_ok
        'Try::Chain',
        qw( $call_m );
}

sub new {
    return bless {}, __PACKAGE__;
}
sub nothing {
    return;
}
sub string {
    return 'foo';
}
sub list {
    return qw( bar baz );
}

lives_ok
    sub {
        my $scalar = __PACKAGE__->new->$call_m('string');
        is
            $scalar,
            'foo',
            'check scalar';
    },
    q{...->new->$call_m('string')};
lives_ok
    sub {
        my @list = __PACKAGE__->new->$call_m('list');
        eq_or_diff
            \@list,
            [ qw( bar baz ) ],
            'check list';
    },
    q{...->new->$call_m('list')};
lives_ok
    sub {
        my $scalar = __PACKAGE__->$call_m('nothing')->$call_m('string');
        eq_or_diff
            $scalar,
            undef,
            'check scalar';
    },
    q{...->$call_m('nothing')->$call_m('string')};
lives_ok
    sub {
        my @list = __PACKAGE__->$call_m('nothing')->$call_m('list');
        eq_or_diff
            \@list,
            [],
            'check list';
    },
    q{...->$call_m('nothing')->$call_m('list')};
