#!perl -T ## no critic (TidyCode)

use strict;
use warnings;

use Try::Chain qw( try_chain try catch finally );

our $VERSION = '0.001';
# create an object
sub new {
    return bless {}, __PACKAGE__;
}
# and some methods
sub nothing {
    return;
}
sub string {
    return 'foo';
}
sub list {
    return qw( bar baz );
}

my $counter = 0;
# string
() = print ++$counter, try_chain { __PACKAGE__->new->string }, "\n";
# list elements
() = print ++$counter, try_chain { __PACKAGE__->new->list   }, "\n";
# nothing because of list context, otherwise undef
() = print ++$counter, try_chain { __PACKAGE__->nothing->string }, "\n";
# nothing because of list context, otherwise undef
() = print ++$counter, try_chain { __PACKAGE__->new->nothing->list   }, "\n";
# undef and $foo also undef because of unchanged $foo with no autovivication
{
    my $foo;
    my $result = try_chain { no autovivification; return $foo->{bar}[0] };
    () = print ++$counter, $result || 'undef', $foo || 'undef', "\n";
}
# unexpected error message
() = print
    ++$counter,
    try_chain { die "error of try_chain\n" }
        catch { $_ }
        finally { () = print ++$counter, 'try_chain finally', "\n" };
# normal try also imported
() = print
    ++$counter,
    try { die "error of try\n" }
        catch { $_ }
        finally { () = print ++$counter, 'try finally', "\n" };

# $Id$

__END__

Output:
1foo
2barbaz
3
4
5undefundef
7finally
7error of try_chain
9finally
9error of try
