package Task::Sites::ShlomiFish;

use warnings;
use strict;

=head1 NAME

Task::Sites::ShlomiFish - Specifications for modules needed by the homesite
of Shlomi Fish.
=cut

our $VERSION = '0.0200';

=head1 DESCRIPTION

Shlomi Fish maintains a homesite at L<http://www.shlomifish.org/>. Installing
this task from CPAN will install all of the CPAN modules that are required
to build it.

=head1 AUTHOR

Shlomi Fish, C<< <shlomif at iglu.org.il> >>

=head1 BUGS

Please report any bugs or feature requests to
C<bug-task-latemp at rt.cpan.org>, or through the web interface at
L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Task-Sites-ShlomiFish>.
I will be notified, and then you'll automatically be notified of progress on
your bug as I make changes.

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Task::Sites::ShlomiFish

You can also look for information at:

=over 4

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Task-Sites-ShlomiFish>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Task-Sites-ShlomiFish>

=item * RT: CPAN's request tracker

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Task-Sites-ShlomiFish>

=item * Search CPAN

L<http://search.cpan.org/dist/Task-Sites-ShlomiFish>

=back

=head1 ACKNOWLEDGEMENTS

=head1 SEE ALSO

L<Task> .

=head1 COPYRIGHT & LICENSE

Copyright 2006 Shlomi Fish, all rights reserved.

This program is released under the following license: bsd

=cut

1;

