# $Id: 13-listable.t,v 1.4 2005/07/31 11:13:53 rvosa Exp $
use strict;
use warnings;
use Test::More tests => 7;
use Bio::Phylo;
use Bio::Phylo::Taxa;
use Bio::Phylo::Taxa::Taxon;
use Bio::Phylo::Trees;
use Bio::Phylo::Trees::Tree;
ok( my $listable = new Bio::Phylo::Listable, '1 initialize object' );
my $trees = new Bio::Phylo::Trees;
$trees->VERBOSE( -level => 0 );
my $tree = new Bio::Phylo::Trees::Tree;
$trees->insert($tree);
my $taxa  = new Bio::Phylo::Taxa;
my $taxon = new Bio::Phylo::Taxa::Taxon;
$taxa->insert($taxon);
ok( !$trees->cross_reference($taxa), '2 bad crossref' );
ok( !$taxa->cross_reference($taxa),  '3 bad crossref' );
ok( !$taxa->insert( new Bio::Phylo ),'4 insert obj bad' );
ok( $trees->first,                   '5 get first tree' );
ok( $trees->last,                    '6 get last tree' );
ok( $tree->cross_reference($taxa),   '7 good crossref' );
