package Dist::Zilla::Plugin::UploadToCPAN::OnePassword 5.026; # TRIAL
# ABSTRACT: upload the dist to CPAN, credentials in 1Password

use Moose;
extends 'Dist::Zilla::Plugin::UploadToCPAN';

use JSON::MaybeXS ();

has op_item_id => (
  is  => 'ro',
  isa => 'Str',
  default => sub {
    my $item_id = $ENV{DZIL_PAUSE_1P_ITEM_ID};

    confess "no op_item_id given and no DZIL_PAUSE_1P_ITEM_ID env var"
      unless length $item_id;

    confess "bogus-looking 1Password item id in DZIL_PAUSE_1P_ITEM_ID"
      unless $item_id =~ /\A\p{PosixAlnum}+\z/;

    $item_id;
  },
);

has op_items => (
  is => 'ro',
  isa => 'HashRef',
  lazy    => 1,
  default => sub {
    my ($self) = @_;
    my $item_id = $self->op_item_id;

    confess "bogus-looking 1Password item id"
      unless $item_id =~ /\A\p{PosixAlnum}+\z/;

    my $json = `op item get --format json $item_id --fields username,password`;

    my $field_aref = JSON::MaybeXS->new->decode($json);

    my %item = map {; $_->{id} => $_->{value} } @$field_aref;

    \%item;
  },
);

has '+username' => (
  default => sub {
    my ($self) = @_;
    $self->op_items->{username};
  }
);

has '+password' => (
  default => sub {
    my ($self) = @_;
    $self->op_items->{password};
  }
);

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Dist::Zilla::Plugin::UploadToCPAN::OnePassword - upload the dist to CPAN, credentials in 1Password

=head1 VERSION

version 5.026

=head1 PERL VERSION

This module is shipped with no promise about what version of perl it will
require in the future.  In practice, this tends to mean "you need a perl from
the last three years," but you can't rely on that.  If a new version of perl
ship, this software B<may> begin to require it for any reason, and there is
no promise that patches will be accepted to lower the minimum required perl.

=head1 AUTHOR

Ricardo Signes <cpan@semiotic.systems>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024 by Ricardo Signes.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
