
use strict;
use warnings;



use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "All these modules are installed on LiveDVDs we give away",
  "AUTHOR" => "Renee Baecker <module\@renee-baecker.de>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "Task-LiveDVD-FrankfurtPM",
  "EXE_FILES" => [],
  "LICENSE" => "artistic_2",
  "NAME" => "Task::LiveDVD::FrankfurtPM",
  "PREREQ_PM" => {
    "Alien::LibXML" => "0.001",
    "Alien::wxWidgets" => "0.62",
    "IO::Async::Loop::Mojo" => "0.03",
    "Mojo::Facebook" => "0.0203",
    "Mojo::Server::FastCGI" => "0.41",
    "Mojo::TFTPd" => "0.01",
    "MojoX::AIO" => "0.05",
    "MojoX::Auth::Simple" => "v0.4.3",
    "MojoX::JSON::RPC" => "0.04",
    "MojoX::Log::Log4perl" => "0.06",
    "MojoX::Logite" => "0.01",
    "MojoX::Ping" => "0.511",
    "MojoX::Renderer::HTC" => "0.01",
    "MojoX::Renderer::WriteExcel" => "1.11",
    "MojoX::Renderer::Xslate" => "0.08",
    "MojoX::Session" => "0.25",
    "MojoX::Validator" => "0.0013",
    "Mojolicious" => "3.87",
    "Mojolicious::Command::deploy" => "0.01",
    "Mojolicious::Command::deploy::heroku" => "0.10",
    "Mojolicious::Command::generate::bootstrap" => "0.01",
    "Mojolicious::Command::generate::bootstrap_app" => "0.01",
    "Mojolicious::Command::generate::nifty_app" => "0.04",
    "Mojolicious::Command::listdeps" => "0.06",
    "Mojolicious::Command::secret" => "0.02",
    "Mojolicious::Plugin::AccessLog" => "0.002",
    "Mojolicious::Plugin::AnyData" => "1.20",
    "Mojolicious::Plugin::Authentication" => "1.24",
    "Mojolicious::Plugin::Authorization" => "1.0301",
    "Mojolicious::Plugin::AutoRoute" => "0.03",
    "Mojolicious::Plugin::BasicAuth" => "0.06",
    "Mojolicious::Plugin::BasicAuthPlus" => "0.03",
    "Mojolicious::Plugin::Bcrypt" => "0.04",
    "Mojolicious::Plugin::BlogSpam" => "0.06",
    "Mojolicious::Plugin::BrowserDetect" => "0.003",
    "Mojolicious::Plugin::Bundle" => "0.004",
    "Mojolicious::Plugin::CHI" => "0.05",
    "Mojolicious::Plugin::CSRFDefender" => "v0.0.6",
    "Mojolicious::Plugin::CSRFProtect" => "0.13",
    "Mojolicious::Plugin::Cache" => "0.0015",
    "Mojolicious::Plugin::Captcha::reCAPTCHA" => "0.04",
    "Mojolicious::Plugin::CaptchaRenderer" => "0.02",
    "Mojolicious::Plugin::ConfigRoutes" => "0.04",
    "Mojolicious::Plugin::ConsoleLogger" => "0.05",
    "Mojolicious::Plugin::CountryDropDown" => "0.06",
    "Mojolicious::Plugin::DBIxTransactionManager" => "0.02",
    "Mojolicious::Plugin::DOCRenderer" => "3.01",
    "Mojolicious::Plugin::DSC" => "0.994",
    "Mojolicious::Plugin::Database" => "1.08",
    "Mojolicious::Plugin::DeCSRF" => "0.93",
    "Mojolicious::Plugin::DigestAuth" => "0.05",
    "Mojolicious::Plugin::Directory" => "0.06",
    "Mojolicious::Plugin::Disqus" => "1.22",
    "Mojolicious::Plugin::DomIdHelper" => "0.04",
    "Mojolicious::Plugin::Dotcloud" => "1.01",
    "Mojolicious::Plugin::EventSource" => "0.3",
    "Mojolicious::Plugin::Facebook" => "0.0203",
    "Mojolicious::Plugin::FormFields" => "0.02",
    "Mojolicious::Plugin::Geo" => "0.02",
    "Mojolicious::Plugin::Gravatar" => "0.02",
    "Mojolicious::Plugin::GroupedParams" => "0.04",
    "Mojolicious::Plugin::HTMLLint" => "0.04",
    "Mojolicious::Plugin::HTMLTemplateRenderer" => "0.03",
    "Mojolicious::Plugin::HTTPStatusRenderer" => "0.01",
    "Mojolicious::Plugin::HamlRenderer" => "2.000001",
    "Mojolicious::Plugin::Human" => "0.5",
    "Mojolicious::Plugin::Humane" => "0.04",
    "Mojolicious::Plugin::I18N" => "0.9",
    "Mojolicious::Plugin::Ident" => "0.28",
    "Mojolicious::Plugin::InstallablePaths" => "0.03",
    "Mojolicious::Plugin::JSONP" => "0.02",
    "Mojolicious::Plugin::JSUrlFor" => "0.09",
    "Mojolicious::Plugin::JavaScript::Console" => "0.01",
    "Mojolicious::Plugin::KossyValidator" => "0.04",
    "Mojolicious::Plugin::Libravatar" => "1.05",
    "Mojolicious::Plugin::LinkedContent" => "0.05",
    "Mojolicious::Plugin::Mail" => "0.94",
    "Mojolicious::Plugin::MailException" => "0.11",
    "Mojolicious::Plugin::MarkaplRenderer" => "v0.2.0",
    "Mojolicious::Plugin::Mason1Renderer" => "0.02",
    "Mojolicious::Plugin::Mason2Renderer" => "0.03",
    "Mojolicious::Plugin::Message::Locale" => "0.03",
    "Mojolicious::Plugin::MethodOverride" => "0.010",
    "Mojolicious::Plugin::Mongodb" => "1.14",
    "Mojolicious::Plugin::MountPSGI" => "0.01",
    "Mojolicious::Plugin::MozPersona" => "0.03",
    "Mojolicious::Plugin::MySQLViewerLite" => "0.14",
    "Mojolicious::Plugin::OAuth2" => "0.8",
    "Mojolicious::Plugin::OnFork" => "0.001",
    "Mojolicious::Plugin::PPI" => "0.03",
    "Mojolicious::Plugin::ParamCondition" => "0.003",
    "Mojolicious::Plugin::ParamExpand" => "0.01",
    "Mojolicious::Plugin::ParamLogger" => "0.01",
    "Mojolicious::Plugin::ParamsAuth" => "0.02",
    "Mojolicious::Plugin::Pedro" => "0.09",
    "Mojolicious::Plugin::Piwik" => "0.08",
    "Mojolicious::Plugin::PlackMiddleware" => "0.24",
    "Mojolicious::Plugin::ProRenderer" => "0.40",
    "Mojolicious::Plugin::Proxy" => "0.3",
    "Mojolicious::Plugin::Recaptcha" => "0.61",
    "Mojolicious::Plugin::RedirectHost" => "0.03",
    "Mojolicious::Plugin::Redis" => "0.03",
    "Mojolicious::Plugin::RenderFile" => "0.05",
    "Mojolicious::Plugin::RequestBase" => "0.01",
    "Mojolicious::Plugin::Resque" => "0.01",
    "Mojolicious::Plugin::SMS" => "0.01",
    "Mojolicious::Plugin::SQLMaker" => "0.03",
    "Mojolicious::Plugin::SQLiteViewerLite" => "0.10",
    "Mojolicious::Plugin::SassRenderer" => "0.02",
    "Mojolicious::Plugin::ServerSession" => "0.01",
    "Mojolicious::Plugin::ShareHelpers" => "0.52",
    "Mojolicious::Plugin::SimpleSession" => "0.01",
    "Mojolicious::Plugin::SslAuth" => "0.07",
    "Mojolicious::Plugin::Subdispatch" => "0.03",
    "Mojolicious::Plugin::Sugar" => "0.001",
    "Mojolicious::Plugin::Toto" => "0.24",
    "Mojolicious::Plugin::TtRenderer" => "1.42",
    "Mojolicious::Plugin::TweetButton" => "0.0003",
    "Mojolicious::Plugin::UrlWith" => "0.0502",
    "Mojolicious::Plugin::Util::Endpoint" => "0.08",
    "Mojolicious::Plugin::ValidateMoose" => "0.02",
    "Mojolicious::Plugin::ValidateTiny" => "0.12",
    "Mojolicious::Plugin::Vparam" => "0.6",
    "Mojolicious::Plugin::WWWSession" => "0.05",
    "Mojolicious::Plugin::Web::Auth" => "0.01",
    "Mojolicious::Plugin::Webtail" => "0.05",
    "Mojolicious::Plugin::Wolowitz" => "v1.0.1",
    "Mojolicious::Plugin::WriteExcel" => "2.01",
    "Mojolicious::Plugin::YamlConfig" => "v0.1.5",
    "Mojolicious::Plugin::YubiVerify" => "0.03",
    "Mojolicious::Plugin::ZombieApocalypse" => "0.01",
    "Moo" => "1.000008",
    "MooX" => "0.101",
    "MooX::ClassAttribute" => "0.006",
    "MooX::Cmd" => "0.002",
    "MooX::Log::Any" => "0.001",
    "MooX::Options" => "3.77",
    "MooX::Role::Pluggable" => "0.120002",
    "MooX::Singleton" => "1.121160",
    "MooX::Types::CLike" => "0.91",
    "MooX::Types::MooseLike" => "0.21",
    "MooX::Types::MooseLike::Email" => "0.03",
    "MooseX::Method::Signatures" => "0.44",
    "Padre" => "0.96",
    "Padre::Plugin::Mojolicious" => "0.06",
    "Plack::Client" => "0.06",
    "Plack::Middleware::Auth::AccessToken" => "0.1",
    "Plack::Middleware::Auth::Digest" => "0.04",
    "Plack::Middleware::Auth::OAuth" => "0.05",
    "Plack::Middleware::Auth::QueryString" => "0.02",
    "Plack::Middleware::CSRFBlock" => "0.06",
    "Plack::Middleware::ChromeFrame" => "0.02",
    "Plack::Middleware::Class::Refresh" => "0.01",
    "Plack::Middleware::Compile" => "0.01",
    "Plack::Middleware::ConsoleLogger" => "0.04",
    "Plack::Middleware::Debug" => "0.14",
    "Plack::Middleware::Debug::Ajax" => "0.02",
    "Plack::Middleware::Debug::Log4perl" => "0.04",
    "Plack::Middleware::Debug::TraceENV" => "0.04",
    "Plack::Middleware::DetectMobileBrowsers" => "0.01",
    "Plack::Middleware::DirIndex" => "0.01",
    "Plack::Middleware::ETag" => "0.03",
    "Plack::Middleware::File::Less" => "0.02",
    "Plack::Middleware::FileWrap" => "0.01",
    "Plack::Middleware::HTMLLint" => "0.01",
    "Plack::Middleware::HTMLMinify" => "v1.0.0",
    "Plack::Middleware::HTMLify" => "v0.1.1",
    "Plack::Middleware::Header" => "0.04",
    "Plack::Middleware::Log::Minimal" => "0.06",
    "Plack::Middleware::MemoryUsage" => "0.02",
    "Plack::Middleware::NeverExpire" => "1.004",
    "Plack::Middleware::Precompressed" => "1.101",
    "Plack::Middleware::Profiler::NYTProf" => "0.14",
    "Plack::Middleware::Proxy::Requests" => "0.01",
    "Plack::Middleware::QRCode" => "0.02",
    "Plack::Middleware::REST" => "0.02",
    "Plack::Middleware::RedirectSSL" => "1.001",
    "Plack::Middleware::RequestHeaders" => "0.031",
    "Plack::Middleware::ReverseProxy" => "0.15",
    "Plack::Middleware::ReverseProxyPath" => "0.03",
    "Plack::Middleware::Rewrite" => "1.007",
    "Plack::Middleware::SocketIO" => "0.00904",
    "Plack::Middleware::Static::Combine" => "0.01",
    "Plack::Middleware::TrafficLog" => "0.0202",
    "Plack::Middleware::XForwardedFor" => "0.103060",
    "Rex" => "v0.40.0",
    "Rex::Apache::Deploy" => "v0.11.0",
    "Rex::Augeas" => "v0.2.0",
    "Rex::Bundle" => "v0.5.0",
    "Rex::Endpoint::HTTP" => "v0.35.0",
    "Rex::Gearman" => "v0.32.0",
    "Rex::IO::CMDB" => "v0.0.3",
    "Rex::IO::Client" => "v0.0.6",
    "Rex::IO::Server" => "v0.0.2",
    "Rex::Template::TT" => "v0.33.1",
    "Starman" => "0.3006",
    "Task::Dancer" => "0.38",
    "Task::Kensho" => "0.33",
    "Task::Kensho::Async" => "0.28",
    "Task::Kensho::CLI" => "0.29",
    "Task::Kensho::Config" => "0.28",
    "Task::Kensho::DBDev" => "0.28",
    "Task::Kensho::Dates" => "0.28",
    "Task::Kensho::Email" => "0.28",
    "Task::Kensho::ExcelCSV" => "0.28",
    "Task::Kensho::Exceptions" => "0.28",
    "Task::Kensho::Hackery" => "0.28",
    "Task::Kensho::Logging" => "0.01",
    "Task::Kensho::ModuleDev" => "0.28",
    "Task::Kensho::OOP" => "0.28",
    "Task::Kensho::Scalability" => "0.28",
    "Task::Kensho::Testing" => "0.29",
    "Task::Kensho::Toolchain" => "0.28",
    "Task::Kensho::WebCrawling" => "0.28",
    "Task::Kensho::WebDev" => "0.29",
    "Task::Kensho::XML" => "0.28",
    "XML::Parser::REX" => "1.01",
    "mojolicious::lexicon" => "0.9922",
    "mojolicious::plugin::page::navigator" => "0.01"
  },
  "VERSION" => "0.02",
  "test" => {
    "TESTS" => ""
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



