#===============================================================================
#      PODNAME:  Net::IP::Identifier::Plugin::Enzu
#     ABSTRACT:  identify Enzu/ScalableDNS owned IP addresses
#
#       AUTHOR:  Reid Augustin (REID)
#        EMAIL:  reid@hellosix.com
#      CREATED:  Tue Nov 11 10:10:29 PST 2014
#===============================================================================

use 5.008;
use strict;
use warnings;

package Net::IP::Identifier::Plugin::Enzu;

use Role::Tiny::With;
with qw( Net::IP::Identifier_Role );

our $VERSION = '0.086'; # VERSION

sub new {
    my ($class, %opts) = @_;

    my $self = {};
    bless $self, (ref $class || $class);

    # List of known Enzu/ScalableDNS IP blocks as of Nov 2014
    $self->ips(qw(
        23.88.0.0 - 23.89.255.255
        23.244.0.0 - 23.245.255.255
        37.77.80.0 - 37.77.95.255
        38.126.44.0/23
        104.151.0.0 - 104.151.255.255
        104.202.0.0 - 104.203.255.255
        107.183.0.0 - 107.183.255.255
        172.246.0.0 - 172.246.255.255
        184.105.219.0 - 184.105.219.255
        188.215.80.0 - 188.215.87.255
        188.215.104.0 - 188.215.111.255
        192.80.128.0 - 192.80.191.255
        192.157.192.0 - 192.157.255.255
        198.56.128.0 - 198.56.255.255
        198.71.80.0 - 198.71.95.255
        198.98.96.0 - 198.98.127.255
        199.48.68.0 - 199.48.71.255
        199.188.72.0 - 199.188.75.255
        199.193.248.0 - 199.193.255.255
        199.229.232.0 - 199.229.235.255
        199.231.208.0 - 199.231.215.255
        2605:F700:: - 2605:F700:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF
    ));
    return $self;
}

sub name {
    return 'Enzu';
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Net::IP::Identifier::Plugin::Enzu - identify Enzu/ScalableDNS owned IP addresses

=head1 VERSION

version 0.086

=head1 SYNOPSIS

 use Net::IP::Identifier::Plugin::Enzu;

=head1 DESCRIPTION

Net::IP::Identifier::Plugin::Enzu identifies Enzu/ScalableDNS host IPs.

=head2 Methods

=over

=item new

Creates a new Net::IP::Identifier::Plugin::Enzu object.

=back

=head1 SEE ALSO

=over

=item IP::Net

=item IP::Net::Identifier

=item IP::Net::Identifier_Role

=back

=head1 AUTHOR

Reid Augustin <reid@hellosix.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Reid Augustin.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
