# $Id: Config.pm.in 1292 2003-08-08 10:15:30Z richardc $
package Siesta::Config;
use strict;
use vars qw( $CONFIG_FILE $ROOT $MESSAGES @STORAGE $ARCHIVE $LOG_PATH $LOG_LEVEL $config );
use AppConfig qw(:expand :argcount);

=head1 NAME 

Siesta::Config - organise the configuration of a Siesta install

=head1 VARIABLES

=head2 C<$ROOT>

Where to install everything to. Currently this is set to 

	/usr/local/siesta

=head2 C<$CONFIG_FILE>

Where the config file is currently 

	/usr/local/siesta/siesta.conf

This can be overridden when using the command line tools by 
using 

	-f <new config file>


=head3 CONFIG OPTIONS

The following options are set within the config file :

=over 4

=item root

override the C<$ROOT> variable above

=item messages

Where our message templates are stored.

By default - /usr/local/siesta/messages/

=item archive

Where we archive list mails.

By default - /usr/local/siesta/archive/<list name>/

=item log_path

Where we log things

By default - /usr/local/siesta/error


=item log_level

By default - 3

=item storage_dsn

The DSN for our local DB

By default - dbi:SQLite:/usr/local/siesta/database/

=item storage_user

The user name for our DB

By default - root

=item storage_pass

The password for our DB

By default - undef

=back 

=head2 C<@STORAGE>

A list containing the dsn, the user and password.

=head1 CREATION

This file is autogenerated from Config.pm.in when you run Build.PL

=cut


sub load_from {
    shift;
    my $file = shift;
    $config->file($file) if -e $file;

    @STORAGE   = ($config->get('storage_dsn'),
                  $config->get('storage_user'),
                  $config->get('storage_pass')),
    $MESSAGES  = $config->get('messages');
    $ARCHIVE   = $config->get('archive');
    $LOG_PATH  = $config->get('log_path');
    $LOG_LEVEL = $config->get('log_level');
}


BEGIN {
    $ROOT = '/usr/local/siesta';
    $CONFIG_FILE = '/usr/local/siesta/siesta.conf' unless defined $CONFIG_FILE;

    $config = AppConfig->new({
            GLOBAL => {                ARGCOUNT => ARGCOUNT_ONE,
                EXPAND => EXPAND_ALL,
            },
        },

        root => {
            DEFAULT => '/usr/local/siesta',
        },
        messages => {
            DEFAULT => '/usr/local/siesta/messages',
        },
        archive => {
            DEFAULT => '/usr/local/siesta/archive',
        },
        log_path => {
            DEFAULT => '/usr/local/siesta/error',
        },
        log_level => {
            DEFAULT => 3,
        },
        storage_dsn => {
            DEFAULT => 'dbi:SQLite:/usr/local/siesta/database',
        },
        storage_user => {
            DEFAULT => 'root',
        },
        storage_pass => {
            DEFAULT => undef,
        },
    );
    __PACKAGE__->load_from( $CONFIG_FILE );
}

1;
