package Alien::libtiff;    ## no critic (Capitalization)

use strict;
use warnings;
use base qw( Alien::Base );

our $VERSION = 1;

1;
__END__

=head1 NAME

Alien::libtiff - install libtiff

=head1 VERSION

1

=head1 SYNOPSIS

Alien::libtiff installs libtiff on those platforms which do not have their own
package manager, in particular Windows.

=head1 DESCRIPTION

Typical Linux distributions do not need Alien::libtiff, as libtiff can be
installed directly.

This was created solely to ensure that Graphics::TIFF could be built, tested and
used on Windows:

 perl Makefile.PL
 make
 make install

=head1 SUBROUTINES/METHODS

=head1 DIAGNOSTICS

=head1 CONFIGURATION AND ENVIRONMENT

=head1 DEPENDENCIES

=head2 Linux

Alien::Base, PkgConfig & Sort::Versions are required to build Alien::libtiff on
a standard Linux distribution.

=head2 Windows

In addition to the above Linux dependencies, to build Alien::libtiff on Windows,
Alien::MSYS is requires to provide tools that autoconf requires.

=head1 INCOMPATIBILITIES

=head1 BUGS AND LIMITATIONS

=head1 SEE ALSO

Graphics::TIFF

The LIBTIFF Standard Reference L<http://www.libtiff.org/libtiff.html> is a handy
companion.

=head1 AUTHOR

Jeffrey Ratcliffe, E<lt>jffry@posteo.netE<gt>

=head1 LICENSE AND COPYRIGHT

Copyright (C) 2021 by Jeffrey Ratcliffe

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.5 or,
at your option, any later version of Perl 5 you may have available.

=cut
