package Forms::Langues_dbc;

use strict;
use warnings;
use Data::Dumper;
use base qw(Wx::App);
use Wx qw(:everything);
use Wx::Event qw(EVT_COMBOBOX EVT_TEXT EVT_TEXT_ENTER EVT_CLOSE);

use Gtk2::Ex::DbLinker::DbcDataManager;
use  Log::Log4perl;

use Wx_dnav;
use Forms::Sflang_dbc;

sub new {
    
    my ( $class, $href ) = @_;
   my $self = $class->SUPER::new();  
   $self->{xrcfolder}=  $$href{xrcfolder};
   $self->{schema} = $$href{schema};
   $self->{dbh} = $self->{schema}->storage->dbh;
   $self->{log} = Log::Log4perl->get_logger(__PACKAGE__);
   $self->{dnav} = Wx_dnav->new({size=> [900,900], main_name=>'mainwindow', main_file=>'../xrc/main.xrc', dbh=> $self->{dbh}});
    $self->{dnav}->load_panel('mainwindow', 'xrc/nav.xrc', 'm_dnav_panel' );

    my $path = $self->{xrcfolder} . "\\content.xrc";
    my $top_panel = $self->{dnav}->load_panel('m_panel_for_content', $path, 'm_panel1');

    $self->{log}->debug(" new form ");

      my $rs = $self->{schema}->resultset('Country')->search_rs(undef, {order_by => 'country'});

    my $dman =  Gtk2::Ex::DbLinker::DbcDataManager->new({
			rs => $rs,
		
		});


     $self->{linker} = Wx::Perl::DbLinker::Wxform->new({ 
		    data_manager => $dman,
		    builder =>  $self->{dnav},
		    rec_spinner => $self->{dnav}->get_object('RecordSpinner'),
  	    	    status_label=>  $self->{dnav}->get_object('lbl_RecordStatus'),
		    rec_count_label => $self->{dnav}->get_object("lbl_RecordCount"),
		    primary_keys => ["countryid"],	
		    datawidgets_changed =>{countryid => sub{ on_countryid_changed($self->{dnav}->get_object('countryid'), $self);}, },
	    });

    # $self->{dnav}->set_form($self->{linker});

  $self->{countryid} = $dman->get_field('countryid');

  #$self->{dnav}->connect_signal_for("countryid", \&on_countryid_changed, $self, "changed");
  #$self->{frame} = $self->{dnav}->frame;
  #my $b = $self->{dnav}->get_object('countryid');
  # EVT_TEXT($self->{frame}, $b,  sub{ $self->{log}->debug("called on Evt_text") });
 #$self->{log}->debug("linked evt_text for countryid");

  #die (Dumper($b));

      my $combodata = Gtk2::Ex::DbLinker::DbcDataManager->new({
		   rs =>  $self->{schema}->resultset('Langue')->search_rs(undef, {sort_by => 'langue'}),
			
		});
       
	$self->{linker}->add_combo({
    		data_manager => $combodata,
	    	id => 'mainlangid',
      });

	$self->{sf} = Forms::Sflang_dbc->new({xrcfolder => $self->{xrcfolder}, 
			schema => $self->{schema} , 
			dnav=>$self->{dnav}, 
			panel_to =>  'panel_subform',
			countryid => $self->{countryid},
		});


	$self->{linker}->add_childform($self->{sf}->{sform});
	
	
	#$sf->show_all_except(["mainwindow"]);

	$self->{linker}->update;

	#$self->{dnav}->connect_signal_for("add", \&on_add_clicked, $self );
	# $self->{dnav}->connect_signal_for("del", \&on_delete_clicked, $self );
	# $self->{dnav}->connect_signal_for("apply", \&on_apply_clicked, $self );

	# show_tables($self);

	 $self->{dnav}->show_all_except([]);
	 # ["countryid",
	 $self->{sf}->{dnav}->show_all_except([ "b_insert"]);

	 $self->{sf}->{sf_list}->{dnav}->show_all_except([]);

	  return $self;

     }

sub OnInit {
1;
}

sub on_countryid_changed {
	my ($b, $self) =@_;
	$self->{log}->debug("countryid_changed called");
	my $value = $b->GetLineText(0);
	return unless defined ($value);
	$self->{log}->debug("on_countryid_changed : $value");
	$self->{countryid} = $value;

	$self->{sf}->on_countryid_changed($value);
 }

 sub on_delete_clicked_todel {
    
    my ($b,$self) = @_;
	$self->{linker}->delete;
 
}

sub on_add_clicked_todel {    
    my ($b, $self) = @_;
    # print Dumper($self);
    $self->{linker}->insert;
    
} 

 sub on_apply_clicked_todel {
     my $b = shift;
    my $self = shift;

    $self->{linker}->apply;

    
}
sub show_tables_todel {
	my $self = shift;
	my $dbh = $self->{dbh};
	my  $sth = $dbh->prepare('SELECT name FROM sqlite_master WHERE type = "table" AND name NOT LIKE "sqlite_%"');
	$sth->execute;
	my $menu = $self->{dnav}->get_object('menu1');
	die unless ($menu);
	while (my @row = $sth->fetchrow_array()){
		# print $row[0],"\n";
		my $t = Gtk2::MenuItem->new($row[0]);
		$t->signal_connect('activate', sub {display_tbl($self, {name => $row[0]});});
		# push @tbl, $t
		$menu->append($t);
		# $t->show;
	}
}

sub display_tbl_todel {

	my %class = (speaks => 'Speak', langues => 'Langue', countries =>'Country');

	my ($self, $href) = @_;
	my $treeview = Gtk2::TreeView->new();
	my $rs_def;
	#my $meta;
	my $data;
	if ($href->{name}){
		$self->{log}->debug("name : " . $href->{name} . " class : " .  $class{$href->{name}});
		my $name = $class{ $href->{name} };
		my $rs = $self->{schema}->resultset($name)->search_rs();
		
		$data = Gtk2::Ex::DbLinker::DbcDataManager->new({ rs => $rs});
	}
	my $f = Forms::Dnav2->new(0);
	my $scroll = Gtk2::ScrolledWindow->new;
	$scroll->add ($treeview);
	$f->add_ctrl($scroll);
	my $rs = Gtk2::Ex::DbLinker::Datasheet->new({
		treeview => $treeview,
		data_manager => $data,
	});
	$rs->update();
	$f->show_all_except(["menubar1"]);
	$f->set_dataref($rs);
	$f->show_all_except();
}



1;
